/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow;

import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.yarnandtail.andhow.AndHowConfiguration;
import org.yarnandtail.andhow.StdConfig;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyConfiguration;
import org.yarnandtail.andhow.api.ValidatedValues;
import org.yarnandtail.andhow.export.PropertyExport;
import org.yarnandtail.andhow.internal.AndHowCore;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.util.AndHowUtil;

public class AndHow
implements PropertyConfiguration,
ValidatedValues {
    public static final String ANDHOW_INLINE_NAME = "AndHow";
    public static final String ANDHOW_NAME = "AndHow!";
    public static final String ANDHOW_URL = "https://github.com/eeverman/andhow";
    public static final String ANDHOW_TAG_LINE = "strong.simple.valid.AppConfiguration";
    private static final Object LOCK = new Object();
    private static volatile AndHow singleInstance;
    private static volatile Initialization initialization;
    private static volatile Boolean initializing;
    private static volatile AndHowConfiguration<? extends AndHowConfiguration> inProcessConfig;
    private static UnaryOperator<AndHowConfiguration<? extends AndHowConfiguration>> configLocator;
    private static final ThreadLocal<Boolean> findingConfig;
    private volatile AndHowCore core;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AndHow(AndHowConfiguration<? extends AndHowConfiguration> config) throws AppFatalException {
        Object object = LOCK;
        synchronized (object) {
            this.core = new AndHowCore(config.getNamingStrategy(), config.buildLoaders(), config.getRegisteredGroups());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndHowConfiguration<? extends AndHowConfiguration> findConfig() throws AppFatalException {
        Object object = LOCK;
        synchronized (object) {
            if (AndHow.isInitialized()) {
                throw new AppFatalException("AndHow is already initialized, so access to configuration is blocked.");
            }
            if (inProcessConfig == null) {
                if (findingConfig.get().booleanValue()) {
                    inProcessConfig = StdConfig.instance();
                } else {
                    findingConfig.set(true);
                    try {
                        inProcessConfig = configLocator != null ? (AndHowConfiguration<Object>)configLocator.apply(StdConfig.instance()) : AndHowUtil.findConfiguration(StdConfig.instance());
                    }
                    finally {
                        findingConfig.remove();
                    }
                }
            }
            return inProcessConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(AndHowConfiguration<? extends AndHowConfiguration> config) throws AppFatalException {
        if (config == null) {
            throw new AppFatalException("Cannot set a null configuration");
        }
        Object object = LOCK;
        synchronized (object) {
            if (AndHow.isInitialized()) {
                throw new AppFatalException("AndHow is already initialized, so access to configuration is blocked.");
            }
            if (findingConfig.get().booleanValue()) {
                throw new AppFatalException("Cannot call AndHow.setConfig() from inside AndHowInit.getConfiguration(). See the user guide for examples of how to configure AndHow.");
            }
            findingConfig.remove();
            inProcessConfig = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndHow instance() throws AppFatalException {
        if (AndHow.isInitialized()) {
            return singleInstance;
        }
        Object object = LOCK;
        synchronized (object) {
            if (AndHow.isInitialized()) {
                return singleInstance;
            }
            return AndHow.initialize(AndHow.findConfig());
        }
    }

    @Deprecated
    public static AndHow instance(AndHowConfiguration config) throws AppFatalException {
        return AndHow.initialize(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    private static AndHow initialize(AndHowConfiguration config) throws AppFatalException {
        Object object = LOCK;
        synchronized (object) {
            if (AndHow.isInitialized()) {
                throw new AppFatalException("AndHow is already initialized - Cannot re-initialize with new configuration");
            }
            if (initializing.booleanValue()) throw new AppFatalException(new ConstructionProblem.InitiationLoopException(initialization, new Initialization(config)));
            initializing = true;
            inProcessConfig = null;
            initialization = new Initialization(config);
            if (singleInstance == null) {
                try {
                    singleInstance = new AndHow(config);
                }
                finally {
                    initializing = false;
                }
            }
            if (AndHow.singleInstance.core != null) throw new IllegalStateException("This exception can never be reached.");
            try {
                AndHowCore newCore;
                AndHow.singleInstance.core = newCore = new AndHowCore(config.getNamingStrategy(), config.buildLoaders(), config.getRegisteredGroups());
            }
            finally {
                initializing = false;
            }
            return singleInstance;
        }
    }

    @Deprecated
    public static boolean isInitialize() {
        return AndHow.isInitialized();
    }

    public static boolean isInitialized() {
        return singleInstance != null && AndHow.singleInstance.core != null;
    }

    public static StackTraceElement[] getInitializationTrace() {
        if (initialization != null) {
            return initialization.getStackTrace();
        }
        return new StackTraceElement[0];
    }

    public Stream<PropertyExport> export(Class<?> ... exportClasses) throws IllegalAccessException {
        return this.core.export(exportClasses);
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.core.isExplicitlySet(prop);
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.core.getExplicitValue(prop);
    }

    @Override
    public <T> T getValue(Property<T> prop) {
        return this.core.getValue(prop);
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return this.core.getAliases(property);
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.core.getCanonicalName(prop);
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.core.getNamingStrategy();
    }

    static {
        initialization = null;
        initializing = false;
        inProcessConfig = null;
        configLocator = null;
        findingConfig = ThreadLocal.withInitial(() -> false);
    }

    public static class Initialization {
        private final StackTraceElement[] stackTrace;
        private final long timeStamp = System.currentTimeMillis();
        private final AndHowConfiguration<? extends AndHowConfiguration> config;

        public Initialization(AndHowConfiguration<? extends AndHowConfiguration> config) {
            StackTraceElement[] ste = new Exception().getStackTrace();
            this.stackTrace = Arrays.copyOfRange(ste, 1, ste.length - 1);
            this.config = config;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public AndHowConfiguration<? extends AndHowConfiguration> getConfig() {
            return this.config;
        }
    }
}

