/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.AndHowConfiguration;
import org.yarnandtail.andhow.PropertyValue;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.StandardLoader;
import org.yarnandtail.andhow.load.KeyObjectPair;
import org.yarnandtail.andhow.load.std.StdEnvVarLoader;
import org.yarnandtail.andhow.load.std.StdFixedValueLoader;
import org.yarnandtail.andhow.load.std.StdJndiLoader;
import org.yarnandtail.andhow.load.std.StdMainStringArgsLoader;
import org.yarnandtail.andhow.load.std.StdPropFileOnClasspathLoader;
import org.yarnandtail.andhow.load.std.StdPropFileOnFilesystemLoader;
import org.yarnandtail.andhow.load.std.StdSysPropLoader;
import org.yarnandtail.andhow.name.CaseInsensitiveNaming;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.util.AndHowUtil;

public abstract class BaseConfig<C extends BaseConfig<C>>
implements AndHowConfiguration<C> {
    protected static final Class<?>[] DEFAULT_LOADER_LIST = new Class[]{StdFixedValueLoader.class, StdMainStringArgsLoader.class, StdSysPropLoader.class, StdEnvVarLoader.class, StdJndiLoader.class, StdPropFileOnFilesystemLoader.class, StdPropFileOnClasspathLoader.class};
    protected List<Class<? extends StandardLoader>> standardLoaders = new ArrayList<Class<? extends StandardLoader>>();
    protected Map<Class<? extends StandardLoader>, List<Loader>> insertBefore = new HashMap<Class<? extends StandardLoader>, List<Loader>>();
    protected Map<Class<? extends StandardLoader>, List<Loader>> insertAfter = new HashMap<Class<? extends StandardLoader>, List<Loader>>();
    protected final List<PropertyValue> _fixedVals = new ArrayList<PropertyValue>();
    protected final List<KeyObjectPair> _fixedKeyObjectPairVals = new ArrayList<KeyObjectPair>();
    protected final List<String> _cmdLineArgs = new ArrayList<String>();
    protected String classpathPropFilePathStr;
    protected StrProp classpathPropFilePathProp;
    protected boolean _missingClasspathPropFileAProblem = false;
    protected StrProp filesystemPropFilePathProp;
    protected boolean _missingFilesystemPropFileAProblem = false;
    protected Properties systemProperties;
    protected Map<String, String> envProperties;
    protected NamingStrategy naming = new CaseInsensitiveNaming();
    protected List<Class<?>> overrideGroups = null;

    protected BaseConfig() {
        this.standardLoaders = this.getDefaultLoaderList();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.naming;
    }

    protected StdFixedValueLoader buildStdFixedValueLoader() {
        StdFixedValueLoader loader = new StdFixedValueLoader();
        loader.setPropertyValues(this._fixedVals);
        loader.setKeyObjectPairValues(this._fixedKeyObjectPairVals);
        return loader;
    }

    protected StdMainStringArgsLoader buildStdMainStringArgsLoader() {
        StdMainStringArgsLoader loader = new StdMainStringArgsLoader();
        loader.setKeyValuePairs(this._cmdLineArgs);
        return loader;
    }

    protected StdSysPropLoader buildStdSysPropLoader() {
        StdSysPropLoader loader = new StdSysPropLoader();
        loader.setMap(this.systemProperties);
        return loader;
    }

    protected StdJndiLoader buildStdJndiLoader() {
        StdJndiLoader loader = new StdJndiLoader();
        return loader;
    }

    protected StdEnvVarLoader buildStdEnvVarLoader() {
        StdEnvVarLoader loader = new StdEnvVarLoader();
        loader.setMap(this.envProperties);
        return loader;
    }

    protected StdPropFileOnFilesystemLoader buildStdPropFileOnFilesystemLoader() {
        StdPropFileOnFilesystemLoader loader = new StdPropFileOnFilesystemLoader();
        loader.setFilePath(this.filesystemPropFilePathProp);
        loader.setMissingFileAProblem(this._missingFilesystemPropFileAProblem);
        return loader;
    }

    protected StdPropFileOnClasspathLoader buildStdPropFileOnClasspathLoader() {
        StdPropFileOnClasspathLoader loader = new StdPropFileOnClasspathLoader();
        loader.setMissingFileAProblem(this._missingClasspathPropFileAProblem);
        if (this.classpathPropFilePathStr != null) {
            loader.setFilePath(this.classpathPropFilePathStr);
        } else if (this.classpathPropFilePathProp != null) {
            loader.setFilePath(this.classpathPropFilePathProp);
        }
        return loader;
    }

    @Override
    public List<Loader> buildLoaders() {
        ArrayList<Loader> loaders = new ArrayList<Loader>();
        for (Class<? extends StandardLoader> clazz : this.standardLoaders) {
            if (this.insertBefore.containsKey(clazz)) {
                loaders.addAll((Collection<Loader>)this.insertBefore.get(clazz));
            }
            String buildMethod = "build" + clazz.getSimpleName();
            Method method = AndHowUtil.findMethod(this.getClass(), buildMethod, new Class[0]);
            if (method != null) {
                try {
                    loaders.add((Loader)method.invoke((Object)this, new Object[0]));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new AppFatalException("Unable to construct the '" + clazz.getCanonicalName() + "' loader", ex);
                }
            } else {
                throw new AppFatalException("There is no loader build method named '" + buildMethod + "'");
            }
            if (!this.insertAfter.containsKey(clazz)) continue;
            loaders.addAll((Collection<Loader>)this.insertAfter.get(clazz));
        }
        return loaders;
    }

    @Override
    public List<GroupProxy> getRegisteredGroups() {
        if (this.overrideGroups != null) {
            return AndHowUtil.buildGroupProxies(this.overrideGroups);
        }
        return null;
    }

    @Override
    public void build() {
        System.err.println("Config.build() is deprecated and will be removed in the next major release. See Javadocs for alternatives.");
        AndHow.instance(this);
    }

    @Override
    public List<Class<? extends StandardLoader>> getDefaultLoaderList() {
        ArrayList<Class<? extends StandardLoader>> loaders = new ArrayList<Class<? extends StandardLoader>>();
        for (Class<?> clazz : DEFAULT_LOADER_LIST) {
            loaders.add(clazz);
        }
        return loaders;
    }
}

