/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.yarnandtail.andhow.api.Problem;

public class ProblemList<P extends Problem>
extends ArrayList<P> {
    public static final ProblemList<Problem> EMPTY_PROBLEM_LIST = new UnmodifiableProblemList<Problem>();

    public ProblemList(int initialCapacity) {
        super(initialCapacity);
    }

    public ProblemList(ProblemList<P> problems) {
        super(problems);
    }

    public ProblemList() {
    }

    @Override
    public boolean add(P problem) {
        if (problem != null) {
            return super.add(problem);
        }
        return false;
    }

    public <P extends Problem> List<P> filter(Class<P> clazz) {
        return this.stream().filter((? super T p) -> clazz.isInstance(p)).map(c -> (Problem)clazz.cast(c)).collect(Collectors.toList());
    }

    public static class UnmodifiableProblemList<P extends Problem>
    extends ProblemList<P> {
        public UnmodifiableProblemList(ProblemList<P> problems) {
            super(problems);
            super.trimToSize();
        }

        public UnmodifiableProblemList() {
            super(0);
        }

        @Override
        public boolean add(P problem) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super P> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<P> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super P> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<P> iterator() {
            final Iterator delegate = super.iterator();
            return new Iterator<P>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public P next() {
                    return (Problem)delegate.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public ListIterator<P> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<P> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends P> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends P> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public P remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, P element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public P set(int index, P element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ensureCapacity(int minCapacity) {
        }

        @Override
        public void trimToSize() {
        }
    }
}

