/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import java.util.List;
import java.util.stream.Collectors;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;

public interface Property<T> {
    public T getValue();

    public T getExplicitValue();

    public T getDefaultValue();

    public boolean isNonNullRequired();

    public PropertyType getPropertyType();

    public ValueType<T> getValueType();

    public Trimmer getTrimmer();

    public String getDescription();

    public List<Validator<T>> getValidators();

    public List<Name> getRequestedAliases();

    public String getHelpText();

    default public List<String> getInAliases() {
        return AndHow.instance().getAliases(this).stream().filter(n -> n.isIn()).map(n -> n.getEffectiveInName()).collect(Collectors.toList());
    }

    default public List<String> getOutAliases() {
        return AndHow.instance().getAliases(this).stream().filter(n -> n.isOut()).map(n -> n.getEffectiveOutName()).collect(Collectors.toList());
    }

    default public String getCanonicalName() {
        return AndHow.instance().getCanonicalName(this);
    }

    default public String getValueAsString() {
        return this.getValueType().toString(this.getValue());
    }

    default public boolean isExplicitlySet() {
        return AndHow.instance().isExplicitlySet(this);
    }
}

