/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.yarnandtail.andhow.AndHowInit;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.compile.AndHowElementScanner7;
import org.yarnandtail.andhow.compile.CompileProblem;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.CompileUtil;
import org.yarnandtail.andhow.compile.PropertyRegistrarClassGenerator;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.util.TextUtil;

@SupportedAnnotationTypes(value={"*"})
public class AndHowCompileProcessor
extends AbstractProcessor {
    private static final String INIT_CLASS_NAME = AndHowInit.class.getCanonicalName();
    private static final String TEST_INIT_CLASS_NAME = "org.yarnandtail.andhow.AndHowTestInit";
    private static final String SERVICES_PACKAGE = "";
    private static final String SERVICE_REGISTRY_META_DIR = "META-INF/services/";
    private static Calendar _runDate;
    private final List<CauseEffect> _registrars = new ArrayList<CauseEffect>();
    private final List<CauseEffect> _initClasses = new ArrayList<CauseEffect>();
    private final List<CauseEffect> _testInitClasses = new ArrayList<CauseEffect>();
    private final List<CompileProblem> _problems = new ArrayList<CompileProblem>();
    private boolean initLogComplete;

    public AndHowCompileProcessor() {
        _runDate = new GregorianCalendar();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(this.unwrap(processingEnv));
    }

    public int getSrcVersion() {
        return CompileUtil.getMajorJavaVersion(this.processingEnv.getSourceVersion());
    }

    public int getJdkVersion() {
        return CompileUtil.getMajorJavaVersion();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        Messager log = this.processingEnv.getMessager();
        int srcVer = this.getSrcVersion();
        int jdkVer = this.getJdkVersion();
        if (!this.initLogComplete) {
            this.initLogComplete = true;
            this.debug(log, "Found java source version: {} jdk version: {}", srcVer, jdkVer);
            if (!CompileUtil.isGeneratedVersionDeterministic(srcVer, jdkVer)) {
                this.warn(log, "The source level is JDK8 ('javac [--release=8] or [-source=8]'), but the current JDK is {}. Thus, the 'Generated' annotation on proxy classes will be commented out.  Not an issue in most cases, but can be fixed by using JDK8 when compiling for JRE8.  See: https://github.com/eeverman/andhow/issues/630", jdkVer);
            }
        }
        if (!roundEnv.processingOver()) {
            this.processNonFinalRound(this.processingEnv, roundEnv, _runDate, filer, log, srcVer, jdkVer, this._problems, this._initClasses, this._testInitClasses, this._registrars);
        } else {
            this.processFinalRound(filer, log, srcVer, jdkVer, this._problems, this._initClasses, this._testInitClasses, this._registrars);
        }
        return false;
    }

    protected void processNonFinalRound(ProcessingEnvironment localProcessingEnv, RoundEnvironment roundEnv, Calendar runDate, Filer filer, Messager log, int srcVersion, int jdkVersion, List<CompileProblem> compileProblems, List<CauseEffect> initCEs, List<CauseEffect> testInitCEs, List<CauseEffect> registrarCEs) {
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement rootTypeElement = (TypeElement)element;
            CompileUnit compileUnit = this.scanTypeElement(localProcessingEnv, rootTypeElement);
            if (compileUnit.istestInitClass()) {
                testInitCEs.add(new CauseEffect(compileUnit.getRootCanonicalName(), rootTypeElement));
            } else if (compileUnit.isInitClass()) {
                initCEs.add(new CauseEffect(compileUnit.getRootCanonicalName(), rootTypeElement));
            }
            if (compileUnit.hasRegistrations() && !compileUnit.hasProblems()) {
                this.debug(log, "Found {} AndHow Properties in class {} ", compileUnit.getRegistrations().size(), compileUnit.getRootCanonicalName());
                PropertyRegistrarClassGenerator gen = new PropertyRegistrarClassGenerator(compileUnit, AndHowCompileProcessor.class, runDate, srcVersion, jdkVersion);
                registrarCEs.add(new CauseEffect(gen.buildGeneratedClassFullName(), rootTypeElement));
                try {
                    this.writeClassFile(filer, gen, element);
                    this.debug(log, "Wrote new generated class file {}", gen.buildGeneratedClassSimpleName());
                }
                catch (Exception ex) {
                    this.error(log, "Unable to write generated classfile '" + gen.buildGeneratedClassFullName() + "'", ex, new Object[0]);
                }
            }
            compileProblems.addAll(compileUnit.getProblems());
        }
    }

    protected void processFinalRound(Filer filer, Messager log, int srcVersion, int jdkVersion, List<CompileProblem> compileProblems, List<CauseEffect> initCEs, List<CauseEffect> testInitCEs, List<CauseEffect> registrarCEs) {
        if (initCEs.size() > 1) {
            compileProblems.add(new CompileProblem.TooManyInitClasses(INIT_CLASS_NAME, initCEs));
        }
        if (testInitCEs.size() > 1) {
            compileProblems.add(new CompileProblem.TooManyInitClasses(TEST_INIT_CLASS_NAME, testInitCEs));
        }
        if (compileProblems.isEmpty()) {
            try {
                if (initCEs.size() == 1) {
                    this.debug(log, "Found exactly 1 {} class: {}", INIT_CLASS_NAME, initCEs.get((int)0).fullClassName);
                    this.writeServiceFile(filer, AndHowInit.class.getCanonicalName(), initCEs);
                }
                if (testInitCEs.size() == 1) {
                    this.debug(log, "Found exactly 1 {} class: {}", TEST_INIT_CLASS_NAME, testInitCEs.get((int)0).fullClassName);
                    this.writeServiceFile(filer, TEST_INIT_CLASS_NAME, testInitCEs);
                }
                if (registrarCEs.size() > 0) {
                    this.debug(log, "Found {} top level classes containing AndHow Properties", registrarCEs.size());
                    this.writeServiceFile(filer, PropertyRegistrar.class.getCanonicalName(), registrarCEs);
                }
            }
            catch (IOException e) {
                this.error(log, "Exception while trying to write generated files", e, new Object[0]);
            }
        } else {
            this.error(log, "AndHow Property definition or Init class errors prevented compilation. Each of the following ({}) errors must be fixed before compilation is possible.", compileProblems.size());
            for (CompileProblem err : compileProblems) {
                this.error(log, err.getFullMessage(), new Object[0]);
            }
        }
    }

    protected CompileUnit scanTypeElement(ProcessingEnvironment localProcessingEnv, TypeElement typeElement) {
        AndHowElementScanner7 st = new AndHowElementScanner7(localProcessingEnv, Property.class.getCanonicalName(), INIT_CLASS_NAME, TEST_INIT_CLASS_NAME);
        return (CompileUnit)st.scan(typeElement);
    }

    public void writeClassFile(Filer filer, PropertyRegistrarClassGenerator generator, Element causingElement) throws Exception {
        String classContent = generator.generateSource();
        JavaFileObject classFile = filer.createSourceFile(generator.buildGeneratedClassFullName(), causingElement);
        try (Writer writer = classFile.openWriter();){
            writer.write(classContent);
        }
    }

    protected void writeServiceFile(Filer filer, String fullyQualifiedServiceInterfaceName, List<CauseEffect> implementingClasses) throws IOException {
        HashSet<Element> set = new HashSet<Element>();
        for (CauseEffect ce : implementingClasses) {
            set.add(ce.causeElement);
        }
        FileObject svsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, SERVICES_PACKAGE, SERVICE_REGISTRY_META_DIR + fullyQualifiedServiceInterfaceName, set.toArray(new Element[set.size()]));
        try (Writer writer = svsFile.openWriter();){
            for (CauseEffect ce : implementingClasses) {
                writer.write(ce.fullClassName);
                writer.write(System.lineSeparator());
            }
        }
    }

    void debug(Messager log, String pattern, Object ... args) {
        log.printMessage(Diagnostic.Kind.NOTE, "AndHowCompileProcessor: " + TextUtil.format(pattern, args));
    }

    void warn(Messager log, String pattern, Object ... args) {
        log.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "AndHowCompileProcessor: " + TextUtil.format(pattern, args));
    }

    void error(Messager log, String pattern, Object ... args) {
        log.printMessage(Diagnostic.Kind.ERROR, "AndHowCompileProcessor: " + TextUtil.format(pattern, args));
    }

    void error(Messager log, String pattern, Throwable thrown, Object ... args) {
        log.printMessage(Diagnostic.Kind.ERROR, "AndHowCompileProcessor: " + TextUtil.format(pattern, args) + System.lineSeparator() + thrown.getMessage());
    }

    private ProcessingEnvironment unwrap(ProcessingEnvironment processingEnv) {
        if (Proxy.isProxyClass(processingEnv.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(processingEnv);
            try {
                Field field = invocationHandler.getClass().getDeclaredField("val$delegateTo");
                field.setAccessible(true);
                Object o = field.get(invocationHandler);
                if (o instanceof ProcessingEnvironment) {
                    return (ProcessingEnvironment)o;
                }
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "got " + o.getClass() + " expected instanceof com.sun.tools.javac.processing.JavacProcessingEnvironment");
                return null;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                return null;
            }
        }
        return processingEnv;
    }

    protected static class CauseEffect {
        String fullClassName;
        Element causeElement;

        public CauseEffect(String fullClassName, Element causeElement) {
            this.fullClassName = fullClassName;
            this.causeElement = causeElement;
        }
    }
}

