/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.yarnandtail.andhow.compile.CompileProblem;
import org.yarnandtail.andhow.compile.SimpleType;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.NameUtil;

public class CompileUnit {
    private final String classCanonName;
    private PropertyRegistrationList registrations;
    private List<CompileProblem> problems;
    private boolean initClass;
    private boolean testInitClass;
    private ArrayDeque<SimpleType> innerPathStack = new ArrayDeque();

    public CompileUnit(String classCanonName) {
        this.classCanonName = classCanonName;
    }

    public boolean isInitClass() {
        return this.initClass;
    }

    public void setInitClass(boolean initClass) {
        this.initClass = initClass;
    }

    public boolean istestInitClass() {
        return this.testInitClass;
    }

    public void setTestInitClass(boolean testInitClass) {
        this.testInitClass = testInitClass;
    }

    public void pushType(SimpleType simpleName) {
        this.innerPathStack.addLast(simpleName);
    }

    public void pushType(String name, boolean _static) {
        this.pushType(new SimpleType(name, _static));
    }

    public SimpleType popType() {
        if (this.innerPathStack.size() == 0) {
            throw new RuntimeException("The nesting order of inner classes is broken - expected to be in an inner class.");
        }
        return this.innerPathStack.pollLast();
    }

    public boolean addProperty(String name, boolean _static, boolean _final) {
        if (_static && _final) {
            if (this.registrations == null) {
                this.registrations = new PropertyRegistrationList(this.classCanonName);
            }
            this.registrations.add(name, this.getInnerPathNames());
            return true;
        }
        if (this.problems == null) {
            this.problems = new ArrayList<CompileProblem>();
        }
        String parentName = NameUtil.getJavaName(this.classCanonName, this.getInnerPathNames());
        if (_static) {
            this.problems.add(new CompileProblem.PropMissingFinal(parentName, name));
        } else if (_final) {
            this.problems.add(new CompileProblem.PropMissingStatic(parentName, name));
        } else {
            this.problems.add(new CompileProblem.PropMissingStaticFinal(parentName, name));
        }
        return false;
    }

    public List<SimpleType> getInnerPath() {
        return new ArrayList<SimpleType>(this.innerPathStack);
    }

    public List<String> getInnerPathNames() {
        ArrayList<String> pathNames;
        if (this.innerPathStack.size() > 0) {
            pathNames = new ArrayList<String>();
            Iterator<SimpleType> it = this.innerPathStack.iterator();
            while (it.hasNext()) {
                pathNames.add(it.next().getName());
            }
        } else {
            pathNames = Collections.EMPTY_LIST;
        }
        return pathNames;
    }

    public String getRootCanonicalName() {
        return this.classCanonName;
    }

    public String getRootSimpleName() {
        int dotPos = this.classCanonName.lastIndexOf(".");
        if (dotPos > 0) {
            return this.classCanonName.substring(dotPos + 1);
        }
        return this.classCanonName;
    }

    public String getRootPackageName() {
        int dotPos = this.classCanonName.lastIndexOf(".");
        if (dotPos > 0) {
            return this.classCanonName.substring(0, dotPos);
        }
        return null;
    }

    public PropertyRegistrationList getRegistrations() {
        return this.registrations;
    }

    public List<CompileProblem> getProblems() {
        if (this.problems != null) {
            return this.problems;
        }
        return Collections.emptyList();
    }

    public boolean hasProblems() {
        return this.problems != null && !this.problems.isEmpty();
    }

    public boolean hasRegistrations() {
        return this.registrations != null && !this.registrations.isEmpty();
    }
}

