/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class BaseLoader
implements Loader {
    @Override
    public Class<?> getClassConfig() {
        return null;
    }

    @Override
    public List<Property> getInstanceConfig() {
        return Collections.emptyList();
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return null;
    }

    protected void attemptToAdd(PropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, String key, String strValue) {
        ReadLoader rl;
        Property prop = this.mapNametoProperty(appConfigDef, key);
        if (prop != null) {
            ValidatedValue validatedValue = null;
            try {
                validatedValue = this.createValue(appConfigDef, prop, strValue);
            }
            catch (ParsingException e) {
                loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, e.getProblemText()));
            }
            this.attemptToAddIfNotDuplicate(appConfigDef, values, loaderProblems, validatedValue);
        } else if (this instanceof ReadLoader && (rl = (ReadLoader)((Object)this)).isUnknownPropertyAProblem()) {
            loaderProblems.add(new LoaderProblem.UnknownPropertyLoaderProblem(this, key));
        }
    }

    protected void attemptToAdd(PropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, String key, Object value) {
        ReadLoader rl;
        Property prop = this.mapNametoProperty(appConfigDef, key);
        if (prop != null) {
            this.attemptToAdd(appConfigDef, values, loaderProblems, prop, value);
        } else if (this instanceof ReadLoader && (rl = (ReadLoader)((Object)this)).isUnknownPropertyAProblem()) {
            loaderProblems.add(new LoaderProblem.UnknownPropertyLoaderProblem(this, key));
        }
    }

    protected void attemptToAdd(PropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, Property prop, Object value) {
        if (prop != null) {
            ValidatedValue validatedValue = null;
            if (value.getClass().equals(prop.getValueType().getDestinationType())) {
                validatedValue = new ValidatedValue(prop, value);
            } else if (value instanceof String) {
                try {
                    validatedValue = this.createValue(appConfigDef, prop, value.toString());
                }
                catch (ParsingException e) {
                    loaderProblems.add(new LoaderProblem.StringConversionLoaderProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, e.getProblemText()));
                }
            } else {
                loaderProblems.add(new LoaderProblem.ObjectConversionValueProblem(this, appConfigDef.getGroupForProperty(prop).getProxiedGroup(), prop, value));
            }
            this.attemptToAddIfNotDuplicate(appConfigDef, values, loaderProblems, validatedValue);
        }
    }

    protected void attemptToAddIfNotDuplicate(PropertyConfigurationInternal appConfigDef, List<ValidatedValue> values, ProblemList<Problem> loaderProblems, ValidatedValue validatedValue) {
        if (validatedValue != null) {
            ValidatedValue dup = this.findDuplicateProperty(validatedValue, values);
            if (dup == null) {
                values.add(validatedValue);
            } else {
                loaderProblems.add(new LoaderProblem.DuplicatePropertyLoaderProblem(this, appConfigDef.getGroupForProperty(validatedValue.getProperty()).getProxiedGroup(), validatedValue.getProperty()));
            }
        }
    }

    protected ValidatedValue findDuplicateProperty(ValidatedValue current, List<ValidatedValue> values) {
        for (ValidatedValue ref : values) {
            if (!current.getProperty().equals(ref.getProperty())) continue;
            return ref;
        }
        return null;
    }

    protected <T> ValidatedValue createValue(PropertyConfigurationInternal appConfigDef, Property<T> prop, String untrimmedString) throws ParsingException {
        Object value = null;
        String trimmed = untrimmedString;
        if (prop.getValueType().getDestinationType().equals(String.class) && this.isTrimmingRequiredForStringValues()) {
            trimmed = prop.getTrimmer().trim(untrimmedString);
        }
        if (trimmed == null && !prop.getPropertyType().isFlag()) {
            return null;
        }
        value = prop.getValueType().parse(trimmed);
        return new ValidatedValue<Object>((Property<Object>)prop, value);
    }

    protected Property mapNametoProperty(PropertyConfigurationInternal appConfigDef, String name) {
        if ((name = TextUtil.trimToNull(name)) != null) {
            Property<?> prop = appConfigDef.getProperty(name);
            return prop;
        }
        return null;
    }

    @Override
    public void releaseResources() {
    }
}

