/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.yarnandtail.andhow.PropertyValue;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.load.KeyObjectPair;

public class FixedValueLoader
extends BaseLoader
implements ReadLoader {
    protected boolean unknownPropertyAProblem = true;
    protected List<PropertyValue> values;
    protected List<KeyObjectPair> keyObjectPairValues;

    public void setPropertyValues(List<PropertyValue> values) {
        this.values = values == null ? null : new ArrayList<PropertyValue>(values);
    }

    @Deprecated
    public void setPropertyValues(PropertyValue ... values) {
        this.setPropertyValues(values != null ? Arrays.asList(values) : null);
    }

    public void setKeyObjectPairValues(List<KeyObjectPair> values) {
        this.keyObjectPairValues = values == null ? null : new ArrayList<KeyObjectPair>(values);
    }

    @Override
    public LoaderValues load(PropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues) {
        ArrayList<ValidatedValue> vvs = this.values == null ? new ArrayList<ValidatedValue>() : new ArrayList(this.values.size());
        ProblemList<Problem> problems = new ProblemList<Problem>();
        if (this.values != null) {
            this.values.stream().forEach(v -> this.attemptToAdd(appConfigDef, (List<ValidatedValue>)vvs, problems, v.getProperty(), v.getValue()));
        }
        if (this.keyObjectPairValues != null) {
            this.keyObjectPairValues.stream().forEach(kop -> this.attemptToAdd(appConfigDef, (List<ValidatedValue>)vvs, problems, kop.getName(), kop.getValue()));
        }
        return new LoaderValues(this, vvs, problems);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "a list of fixed values passed in during startup (not dynamically loaded)";
    }

    @Override
    public String getLoaderType() {
        return "FixedValue";
    }

    @Override
    public String getLoaderDialect() {
        return "FromJavaSourceCode";
    }

    @Override
    public void setUnknownPropertyAProblem(boolean isAProblem) {
        this.unknownPropertyAProblem = isAProblem;
    }

    @Override
    public boolean isUnknownPropertyAProblem() {
        return this.unknownPropertyAProblem;
    }

    @Override
    public void releaseResources() {
        this.values = null;
        this.keyObjectPairValues = null;
    }
}

