/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.GroupInfo;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.sample.TextLine;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class BaseSamplePrinter
implements SamplePrinter {
    abstract PrintFormat getFormat();

    public abstract TextBlock getSampleFileStart();

    public abstract TextBlock getSampleStartComment(PropertyConfigurationInternal var1);

    public abstract String getInAliaseString(PropertyConfigurationInternal var1, EffectiveName var2);

    public abstract TextBlock getActualProperty(PropertyConfigurationInternal var1, GroupProxy var2, Property var3) throws Exception;

    public abstract TextBlock getSampleFileEnd();

    protected void printIfNotNull(PrintStream out, String line) {
        if (line != null) {
            out.println(line);
        }
    }

    protected void print(PrintStream out, TextBlock block, PrintFormat format) {
        if (block == null) {
            return;
        }
        boolean useBlockComment = false;
        boolean useLineComment = false;
        if (block.isBlankLineBefore()) {
            out.println();
        }
        if (block.isComment()) {
            useLineComment = format.usesLineComments();
            useBlockComment = format.usesBlockComments();
        }
        if (useBlockComment) {
            if (block.getLines().size() == 1) {
                TextLine line = block.getLine(0);
                if (block.isWrap()) {
                    List<String> lines = line.getWrappedBlockComment(format, true, true);
                    lines.stream().forEachOrdered(l -> out.println((String)l));
                } else {
                    out.println(line.getBlockComment(format, true, true));
                }
            } else {
                for (int rowToPrint = 0; rowToPrint < block.getLines().size(); ++rowToPrint) {
                    boolean isLastLine;
                    TextLine line = block.getLine(rowToPrint);
                    boolean isFirstLine = rowToPrint == 0;
                    boolean bl = isLastLine = rowToPrint == block.getLines().size() - 1;
                    if (line.wrap.booleanValue()) {
                        List<String> lines = line.getWrappedBlockComment(format, isFirstLine, isLastLine);
                        lines.stream().forEachOrdered(l -> out.println((String)l));
                        continue;
                    }
                    String lineStr = line.getBlockComment(format, isFirstLine, isLastLine);
                    out.println(lineStr);
                }
            }
        } else if (useLineComment) {
            for (TextLine line : block.getLines()) {
                if (line.wrap.booleanValue()) {
                    List<String> lines = line.getWrappedLineComment(format);
                    lines.stream().forEachOrdered(l -> out.println((String)l));
                    continue;
                }
                out.println(line.getLineComment(format));
            }
        } else {
            for (TextLine line : block.getLines()) {
                if (line instanceof TextLine.HRLine) {
                    if (format.usesBlockComments()) {
                        out.println(line.getBlockComment(format, true, true));
                        continue;
                    }
                    out.println(line.getLineComment(format));
                    continue;
                }
                if (line.wrap.booleanValue()) {
                    List<String> lines = line.getWrappedLine(format);
                    lines.stream().forEachOrdered(l -> out.println((String)l));
                    continue;
                }
                out.println(line.getLine(format));
            }
        }
        if (block.isBlankLineAfter()) {
            out.println();
        }
    }

    @Override
    public void printSampleStart(PropertyConfigurationInternal definition, PrintStream out) {
        this.print(out, this.getSampleFileStart(), this.getFormat());
        TextBlock tb = this.getSampleStartComment(definition);
        if (tb != null) {
            tb.setBlankLineAfter(true);
            this.print(out, tb, this.getFormat());
        }
    }

    @Override
    public void printPropertyGroupStart(PropertyConfigurationInternal definition, PrintStream out, GroupProxy group) {
        TextBlock tb = new TextBlock(true, true);
        tb.setBlankLineAfter(true);
        tb.addHR();
        String name = null;
        String desc = null;
        GroupInfo groupDesc = group.getProxiedGroup().getAnnotation(GroupInfo.class);
        if (groupDesc != null) {
            name = TextUtil.trimToNull(groupDesc.name());
            desc = TextUtil.trimToNull(groupDesc.desc());
        }
        if (name != null || desc != null) {
            if (name != null && desc != null) {
                if (!desc.endsWith(".")) {
                    desc = desc + ".";
                }
                tb.addLine(TextUtil.format("Property Group '{}' - {}", name, desc));
                tb.addLine(TextUtil.format("Defined in {}", group.getCanonicalName()));
            } else {
                tb.addLine(TextUtil.format("Property Group {}", group.getCanonicalName()));
                tb.addLine(TextUtil.format("Description: {}", name != null ? name : desc));
            }
        } else {
            tb.addLine(TextUtil.format("Property Group {}", group.getCanonicalName()));
        }
        this.print(out, tb, this.getFormat());
    }

    @Override
    public void printProperty(PropertyConfigurationInternal definition, PrintStream out, GroupProxy group, Property<?> prop) {
        TextBlock tb = new TextBlock(true, true);
        tb.addBlank();
        try {
            String propFieldName = group.getSimpleName(prop);
            tb.addLine(TextUtil.format("{} ({}) {}{}", propFieldName, prop.getValueType().getDestinationType().getSimpleName(), prop.isNonNullRequired() ? "NON-NULL" : "", TextUtil.trimToNull(prop.getDescription()) == null ? "" : " - " + prop.getDescription()));
            List<EffectiveName> effAliases = definition.getAliases(prop);
            ArrayList inAliases = new ArrayList();
            effAliases.stream().filter(a -> a.isIn()).forEachOrdered(a -> inAliases.add(this.getInAliaseString(definition, (EffectiveName)a)));
            if (inAliases.size() > 0) {
                tb.addLine(TextUtil.format("Recognized aliases: {}", String.join((CharSequence)", ", inAliases)));
            }
            if (prop.getDefaultValue() != null) {
                tb.addLine("Default Value: " + prop.getDefaultValue());
            }
            if (TextUtil.trimToNull(prop.getHelpText()) != null) {
                tb.addLine(prop.getHelpText());
            }
            if (prop.getValidators().size() == 1) {
                tb.addLine(TextUtil.format("The property value must " + prop.getValidators().get(0).getTheValueMustDescription(), new Object[0]));
            }
            if (prop.getValidators().size() > 1) {
                tb.addLine("The property value must:");
                for (Validator<?> v : prop.getValidators()) {
                    tb.addLine("\t- " + v.getTheValueMustDescription());
                }
            }
            this.print(out, tb, this.getFormat());
            TextBlock aptb = this.getActualProperty(definition, group, prop);
            aptb.setBlankLineAfter(true);
            this.print(out, aptb, this.getFormat());
        }
        catch (Exception ex) {
            tb.addLine(TextUtil.format("EXCEPTION WHILE INSPECTING A PROPERTY IN '{}'. IS THERE A SECURITY MANAGER BLOCKING REFLECTION? EXCEPTION TYPE: {}", group.getCanonicalName(), ex.getClass().getName()));
            this.print(out, tb, this.getFormat());
        }
    }

    @Override
    public void printPropertyGroupEnd(PropertyConfigurationInternal definition, PrintStream out, GroupProxy group) {
    }

    @Override
    public void printSampleEnd(PropertyConfigurationInternal definition, PrintStream out) {
        TextBlock tb = this.getSampleFileEnd();
        this.print(out, tb, this.getFormat());
    }
}

