/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.sample.BaseSamplePrinter;
import org.yarnandtail.andhow.sample.JndiFileFormat;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.util.TextUtil;

public class JndiLoaderSamplePrinter
extends BaseSamplePrinter
implements SamplePrinter {
    protected PrintFormat format = new JndiFileFormat();

    @Override
    public PrintFormat getFormat() {
        return this.format;
    }

    @Override
    public TextBlock getSampleFileStart() {
        TextBlock tb = new TextBlock(false, false);
        tb.addLine("<Context>");
        return tb;
    }

    @Override
    public TextBlock getSampleStartComment(PropertyConfigurationInternal definition) {
        TextBlock tb = new TextBlock(true, true);
        tb.addHR();
        tb.addLine("Sample JNDI config file generated by AndHow!");
        tb.addLine("strong.simple.valid.AppConfiguration  -  https://github.com/eeverman/andhow");
        tb.addLine("This sample uses Tomcat syntax. JNDI configuration for other servers will be similar.");
        tb.addHR();
        return tb;
    }

    @Override
    public String getInAliaseString(PropertyConfigurationInternal definition, EffectiveName name) {
        return definition.getNamingStrategy().getUriName(name.getActualName());
    }

    @Override
    public TextBlock getActualProperty(PropertyConfigurationInternal definition, GroupProxy group, Property prop) throws Exception {
        TextBlock tb = new TextBlock(false, true);
        String propCanonName = definition.getNamingStrategy().getUriName(group.getCanonicalName(prop));
        String type = prop.getValueType().getDestinationType().getCanonicalName();
        tb.addLine(TextUtil.format("<Environment name=\"{}\" value=\"{}\" type=\"{}\" override=\"false\"/>", propCanonName, "", type));
        return tb;
    }

    @Override
    public TextBlock getSampleFileEnd() {
        TextBlock tb = new TextBlock(false, false);
        tb.addLine("</Context>");
        return tb;
    }

    @Override
    public String getSampleFileExtension() {
        return "xml";
    }
}

