/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.io.PrintStream;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.yarnandtail.andhow.util.AndHowLogFormatter;

public class AndHowLogHandler
extends Handler {
    public static final String MANDATORY_NOTE_PREFIX = "!!Important Note!! ";
    private PrintStream errStream = null;
    private PrintStream outStream = null;

    public AndHowLogHandler() {
        this.configure();
    }

    public AndHowLogHandler(PrintStream errStream, PrintStream outStream) {
        this.errStream = errStream;
        this.outStream = outStream;
    }

    public PrintStream getErrStream() {
        if (this.errStream != null) {
            return this.errStream;
        }
        return System.err;
    }

    public void setErrStream(PrintStream errStream) {
        this.errStream = errStream;
    }

    public PrintStream getNonErrStream() {
        if (this.outStream != null) {
            return this.outStream;
        }
        return System.out;
    }

    public void setNonErrStream(PrintStream outStream) {
        this.outStream = outStream;
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.ALL));
        this.setFilter(this.getFilterProperty(cname + ".filter", null));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new AndHowLogFormatter()));
    }

    protected void publishMandatoryNote(LogRecord record) {
        try {
            String msg = this.getFormatter().format(record);
            if (msg.contains(MANDATORY_NOTE_PREFIX)) {
                msg = msg.replace(MANDATORY_NOTE_PREFIX, "");
            }
            this.getNonErrStream().print(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getMessage().startsWith(MANDATORY_NOTE_PREFIX)) {
            this.publishMandatoryNote(record);
        } else if (this.isLoggable(record)) {
            String msg;
            try {
                msg = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            if (record.getLevel().equals(Level.SEVERE)) {
                this.getErrStream().print(msg);
            } else {
                this.getNonErrStream().print(msg);
            }
        }
    }

    @Override
    public void flush() {
        this.getErrStream().flush();
        this.getNonErrStream().flush();
    }

    @Override
    public void close() throws SecurityException {
        this.killStream(this.errStream);
        this.killStream(this.outStream);
        this.errStream = System.err;
        this.outStream = System.out;
    }

    protected void killStream(PrintStream printStream) {
        if (printStream != null && !System.err.equals(printStream) && !System.out.equals(printStream)) {
            printStream.close();
        }
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

