/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import java.math.BigDecimal;
import org.yarnandtail.andhow.api.Validator;

public abstract class BigDecValidator
implements Validator<BigDecimal> {
    final BigDecimal ref;

    BigDecValidator(BigDecimal ref) {
        this.ref = ref;
    }

    @Override
    public boolean isSpecificationValid() {
        return this.ref != null;
    }

    @Override
    public String getInvalidSpecificationMessage() {
        return "The constraint may not be null";
    }

    public static class LessThanOrEqualTo
    extends BigDecValidator {
        public LessThanOrEqualTo(BigDecimal ref) {
            super(ref);
        }

        @Override
        public boolean isValid(BigDecimal value) {
            return value != null && value.compareTo(this.ref) <= 0;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than or equal to " + this.ref;
        }
    }

    public static class LessThan
    extends BigDecValidator {
        public LessThan(BigDecimal ref) {
            super(ref);
        }

        @Override
        public boolean isValid(BigDecimal value) {
            return value != null && value.compareTo(this.ref) < 0;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than " + this.ref;
        }
    }

    public static class GreaterThanOrEqualTo
    extends BigDecValidator {
        public GreaterThanOrEqualTo(BigDecimal ref) {
            super(ref);
        }

        @Override
        public boolean isValid(BigDecimal value) {
            return value != null && value.compareTo(this.ref) >= 0;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than or equal to " + this.ref;
        }
    }

    public static class GreaterThan
    extends BigDecValidator {
        public GreaterThan(BigDecimal ref) {
            super(ref);
        }

        @Override
        public boolean isValid(BigDecimal value) {
            return value != null && value.compareTo(this.ref) > 0;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than " + this.ref;
        }
    }
}

