/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import org.yarnandtail.andhow.api.Validator;

public abstract class IntValidator
implements Validator<Integer> {
    @Override
    public boolean isSpecificationValid() {
        return true;
    }

    @Override
    public String getInvalidSpecificationMessage() {
        return "THIS VALIDATION IS ALWAYS VALID";
    }

    public static class LessThanOrEqualTo
    extends IntValidator {
        private int ref;

        public LessThanOrEqualTo(int ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Integer value) {
            if (value != null) {
                return value <= this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than or equal to " + Integer.toString(this.ref);
        }
    }

    public static class LessThan
    extends IntValidator {
        private int ref;

        public LessThan(int ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Integer value) {
            if (value != null) {
                return value < this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be less than " + Integer.toString(this.ref);
        }
    }

    public static class GreaterThanOrEqualTo
    extends IntValidator {
        private int ref;

        public GreaterThanOrEqualTo(int ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Integer value) {
            if (value != null) {
                return value >= this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than or equal to " + Integer.toString(this.ref);
        }
    }

    public static class GreaterThan
    extends IntValidator {
        private int ref;

        public GreaterThan(int ref) {
            this.ref = ref;
        }

        @Override
        public boolean isValid(Integer value) {
            if (value != null) {
                return value > this.ref;
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be greater than " + Integer.toString(this.ref);
        }
    }
}

