/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.valid;

import java.util.Arrays;
import org.yarnandtail.andhow.api.Validator;

public class StringValidator {

    public static class Regex
    implements Validator<String> {
        private String regex;

        public Regex(String regex) {
            this.regex = regex;
        }

        @Override
        public boolean isSpecificationValid() {
            try {
                "".matches(this.regex);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The expression '" + this.regex + "' is not a valid regex expression";
        }

        @Override
        public boolean isValid(String value) {
            return value != null && value.matches(this.regex);
        }

        @Override
        public String getTheValueMustDescription() {
            return "match the regex expression '" + this.regex + "'";
        }
    }

    public static class EndsWith
    implements Validator<String> {
        private String sufix;
        private boolean ignoreCase;

        public EndsWith(String sufix, boolean ignoreCase) {
            this.sufix = sufix;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.sufix != null;
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The EndWith expression cannot be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                if (this.ignoreCase) {
                    return value.toUpperCase().endsWith(this.sufix.toUpperCase());
                }
                return value.endsWith(this.sufix);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "end with '" + this.sufix + "'";
        }
    }

    public static class StartsWith
    implements Validator<String> {
        private String prefix;
        private boolean ignoreCase;

        public StartsWith(String prefix, boolean ignoreCase) {
            this.prefix = prefix;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.prefix != null;
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The StartsWith expression cannot be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                if (this.ignoreCase) {
                    return value.toUpperCase().startsWith(this.prefix.toUpperCase());
                }
                return value.startsWith(this.prefix);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "start with '" + this.prefix + "'";
        }
    }

    public static class OneOfIgnoringCase
    implements Validator<String> {
        String[] values;

        public OneOfIgnoringCase(String ... values) {
            this.values = values;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.values != null && this.values.length != 0 && !Arrays.asList(this.values).contains(null);
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The list must contain at least one value and none of the values can be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                return Arrays.stream(this.values).anyMatch(value::equalsIgnoreCase);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be equal to one of '" + Arrays.deepToString(this.values) + "' ignoring case";
        }
    }

    public static class OneOf
    implements Validator<String> {
        String[] values;

        public OneOf(String ... values) {
            this.values = values;
        }

        @Override
        public boolean isSpecificationValid() {
            return this.values != null && this.values.length != 0 && !Arrays.asList(this.values).contains(null);
        }

        @Override
        public String getInvalidSpecificationMessage() {
            return "The list must contain at least one value and none of the values can be null";
        }

        @Override
        public boolean isValid(String value) {
            if (value != null) {
                return Arrays.stream(this.values).anyMatch(value::equals);
            }
            return false;
        }

        @Override
        public String getTheValueMustDescription() {
            return "be equal to one of '" + Arrays.deepToString(this.values) + "'";
        }
    }
}

