package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.AndHow;
import org.yarnandtail.andhow.api.*;
import org.yarnandtail.andhow.util.TextUtil;
import org.yarnandtail.andhow.valuetype.FlagType;

/**
 * Prints configuration templates for properties files.
 */
public class PropFileLoaderSamplePrinter extends BaseSamplePrinter implements SamplePrinter {
	protected PrintFormat format = new PropFileFormat();

	public PropFileLoaderSamplePrinter() {
	}

	@Override
	public PrintFormat getFormat() {
		return format;
	}


	@Override
	public TextBlock getSampleFileStart() {
		return null;
	}

	@Override
	public TextBlock getSampleStartComment(PropertyConfigurationInternal definition) {
		TextBlock tb = new TextBlock(true, true);
		tb.addHR();
		tb.addLine("Sample properties file generated by " + AndHow.ANDHOW_NAME);
		tb.addLine(AndHow.ANDHOW_TAG_LINE + "  -  " + AndHow.ANDHOW_URL);
		tb.addLine("Note: "+ definition.getNamingStrategy().getNameMatchingDescription());
		tb.addHR();
		return tb;

	}

	@Override
	public String getInAliaseString(PropertyConfigurationInternal definition, EffectiveName name) {
		return name.getActualName();
	}

	@Override
	public TextBlock getActualProperty(PropertyConfigurationInternal definition,
                                       GroupProxy group, Property prop) throws Exception {

		TextBlock tb;
		String propCanonName = group.getCanonicalName(prop);

		if (! (prop.getValueType() instanceof FlagType)) {
			tb = new TextBlock(false, false);
		} else {
			// Flags are read as True just by being present, so comment out.
			tb = new TextBlock(false, true);
		}

		tb.addLine(
				TextUtil.format("{} = ", propCanonName)
		);


		return tb;
	}

	@Override
	public TextBlock getSampleFileEnd() {
		return null;
	}

	@Override
	public String getSampleFileExtension() {
		return "properties";
	}
}
