/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow;

import org.yarnandtail.andhow.api.Property;

public class PropertyValue<T> {
    private final Property<T> property;
    private final T value;

    public PropertyValue(Property<T> prop, T value) {
        this.property = prop;
        this.value = value;
        if (this.property == null) {
            throw new RuntimeException("Cannot assign a null property as a PropertyValue instance.");
        }
    }

    public boolean equals(Object obj) {
        boolean basicPropsEq = false;
        if (obj instanceof PropertyValue) {
            PropertyValue other = (PropertyValue)obj;
            if (this.property == other.property) {
                if (this.value != null && other.value != null) {
                    basicPropsEq = this.value.equals(other.value);
                } else if (this.value == null && other.value == null) {
                    basicPropsEq = true;
                }
            }
        }
        return basicPropsEq;
    }

    public int hashCode() {
        int hash = 7;
        if (this.property != null) {
            hash *= this.property.hashCode();
        }
        if (this.value != null) {
            hash *= this.value.hashCode();
        }
        return hash;
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public T getValue() {
        return this.value;
    }
}

