/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.NameAndProperty;

public abstract class GroupProxyBase
implements GroupProxy {
    private final boolean userGroup;
    private final String canonicalName;
    private final String javaCanonicalName;
    protected final List<NameAndProperty> props;

    public GroupProxyBase(String canonicalName, String javaCanonicalName) {
        this.canonicalName = canonicalName;
        this.javaCanonicalName = javaCanonicalName;
        this.props = new ArrayList<NameAndProperty>();
        this.userGroup = true;
    }

    public GroupProxyBase(String canonicalName, String javaCanonicalName, List<NameAndProperty> props, boolean userGroup) {
        this.canonicalName = canonicalName;
        this.javaCanonicalName = javaCanonicalName;
        this.props = props;
        this.userGroup = userGroup;
    }

    @Override
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public String getJavaCanonicalName() {
        return this.javaCanonicalName;
    }

    @Override
    public List<NameAndProperty> getProperties() {
        return Collections.unmodifiableList(this.props);
    }

    @Override
    public Class<?> getProxiedGroup() {
        try {
            String jcan = this.getJavaCanonicalName();
            return Class.forName(jcan);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("The configured PropertyGroup '" + this.getJavaCanonicalName() + "' was not found on the classpath", ex);
        }
    }

    @Override
    public String getSimpleName(Property<?> memberProperty) {
        for (NameAndProperty nap : this.props) {
            if (!nap.property.equals(memberProperty)) continue;
            return nap.fieldName;
        }
        return null;
    }

    @Override
    public String getCanonicalName(Property<?> memberProperty) {
        for (NameAndProperty nap : this.props) {
            if (!nap.property.equals(memberProperty)) continue;
            return this.canonicalName + "." + nap.fieldName;
        }
        return null;
    }

    @Override
    public boolean isUserGroup() {
        return this.userGroup;
    }
}

