/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import javax.lang.model.SourceVersion;

public class CompileUtil {
    public static final String JDK8_GEN_CLASS = "javax.annotation.Generated";
    public static final String JDK9UP_GEN_CLASS = "javax.annotation.processing.Generated";

    private CompileUtil() {
    }

    public static String getGeneratedAnnotationClassName(int jdkMajorVersion) {
        if (jdkMajorVersion < 9) {
            return JDK8_GEN_CLASS;
        }
        return JDK9UP_GEN_CLASS;
    }

    public static boolean isGeneratedVersionDeterministic(int sourceVersion, int jdkMajorVersion) {
        return sourceVersion > 8 || jdkMajorVersion <= 8;
    }

    public static int getMajorJavaVersion(SourceVersion srcVersion) {
        return srcVersion.ordinal();
    }

    public static int getMajorJavaVersion() {
        return CompileUtil.getMajorJavaVersion(System.getProperty("java.version"));
    }

    public static int getMajorJavaVersion(String versionString) {
        String[] versionParts = versionString.split("[\\.\\-_]", 3);
        try {
            if ("1".equals(versionParts[0])) {
                return Integer.parseInt(versionParts[1]);
            }
            return Integer.parseInt(versionParts[0]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("AndHow couldn't parse '" + versionString + "' as a 'java.version' string in System.properties. Is this a non-standard JDK? ", e);
        }
    }
}

