/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;

public class PropertyConfigurationImmutable
implements PropertyConfigurationInternal {
    private final NamingStrategy namingStrategy;
    private final List<GroupProxy> groupList;
    private final List<Property<?>> properties;
    private final Map<GroupProxy, List<Property<?>>> propertiesByGroup;
    private final Map<String, Property<?>> propertiesByAnyName;
    private final Map<Property<?>, List<EffectiveName>> aliasesByProperty;
    private final Map<Property<?>, String> canonicalNameByProperty;
    private final List<ExportGroup> exportGroups;

    public PropertyConfigurationImmutable(NamingStrategy namingStrategy, List<GroupProxy> groupList, List<Property<?>> properties, Map<GroupProxy, List<Property<?>>> propertiesByGroup, Map<String, Property<?>> propertiesByAnyName, Map<Property<?>, List<EffectiveName>> aliasesByProperty, Map<Property<?>, String> canonicalNameByProperty, List<ExportGroup> exportGroups) {
        this.namingStrategy = namingStrategy;
        ArrayList<GroupProxy> gl = new ArrayList<GroupProxy>();
        gl.addAll(groupList);
        gl.trimToSize();
        this.groupList = Collections.unmodifiableList(gl);
        ArrayList props = new ArrayList();
        props.addAll(properties);
        props.trimToSize();
        this.properties = Collections.unmodifiableList(props);
        HashMap propsByGrp = new HashMap();
        propsByGrp.putAll(propertiesByGroup);
        this.propertiesByGroup = Collections.unmodifiableMap(propsByGrp);
        HashMap propsByName = new HashMap();
        propsByName.putAll(propertiesByAnyName);
        this.propertiesByAnyName = Collections.unmodifiableMap(propsByName);
        HashMap alsByProp = new HashMap();
        alsByProp.putAll(aliasesByProperty);
        this.aliasesByProperty = Collections.unmodifiableMap(alsByProp);
        HashMap canonByProp = new HashMap();
        canonByProp.putAll(canonicalNameByProperty);
        this.canonicalNameByProperty = Collections.unmodifiableMap(canonByProp);
        ArrayList<ExportGroup> expGroups = new ArrayList<ExportGroup>();
        expGroups.addAll(exportGroups);
        expGroups.trimToSize();
        this.exportGroups = Collections.unmodifiableList(expGroups);
    }

    @Override
    public Property<?> getProperty(String classpathStyleName) {
        return this.propertiesByAnyName.get(this.namingStrategy.toEffectiveName(classpathStyleName));
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return Collections.unmodifiableList(this.aliasesByProperty.get(property));
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.canonicalNameByProperty.get(prop);
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    public List<GroupProxy> getPropertyGroups() {
        return this.groupList;
    }

    @Override
    public boolean containsUserGroups() {
        for (GroupProxy g : this.getPropertyGroups()) {
            if (!g.isUserGroup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Property<?>> getPropertiesForGroup(GroupProxy group) {
        List<Property<?>> pts = this.propertiesByGroup.get(group);
        if (pts != null) {
            return Collections.unmodifiableList(pts);
        }
        return EMPTY_PROPERTY_LIST;
    }

    @Override
    public GroupProxy getGroupForProperty(Property<?> prop) {
        for (GroupProxy group : this.groupList) {
            if (!this.propertiesByGroup.get(group).contains(prop)) continue;
            return group;
        }
        return null;
    }

    @Override
    public List<ExportGroup> getExportGroups() {
        return this.exportGroups;
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

