/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.ValidatedValuesImmutable;

public abstract class ValidatedValuesWithContextBase
implements ValidatedValuesWithContext {
    protected final <T> T getExplicitValue(List<LoaderValues> valuesList, Property<T> prop) {
        return prop.getValueType().cast(valuesList.stream().filter(lv -> lv.isExplicitlySet(prop)).map(lv -> lv.getExplicitValue(prop)).findFirst().orElse(null));
    }

    protected final <T> T getEffectiveValue(List<LoaderValues> valuesList, Property<T> prop) {
        T v = this.getExplicitValue(valuesList, prop);
        if (v != null) {
            return v;
        }
        return prop.getDefaultValue();
    }

    protected final boolean isPropertyPresent(List<LoaderValues> valuesList, Property<?> prop) {
        return valuesList.stream().anyMatch(pv -> pv.isExplicitlySet(prop));
    }

    protected final LoaderValues getAllValuesLoadedByLoader(List<LoaderValues> valuesList, Loader loader) {
        return valuesList.stream().filter(lv -> lv.getLoader().equals(loader)).findFirst().get();
    }

    public LoaderValues getEffectiveValuesLoadedByLoader(List<LoaderValues> valuesList, Loader loader) {
        LoaderValues allLoaderValues = this.getAllValuesLoadedByLoader(loader);
        if (allLoaderValues != null) {
            ArrayList<ValidatedValue> effValues = new ArrayList<ValidatedValue>(allLoaderValues.getValues());
            for (LoaderValues lvs : valuesList) {
                if (lvs.getLoader().equals(loader)) break;
                effValues.removeIf(pv -> lvs.isExplicitlySet(pv.getProperty()));
            }
            return new LoaderValues(loader, effValues, ProblemList.EMPTY_PROBLEM_LIST);
        }
        return null;
    }

    public ValidatedValuesImmutable buildValueMapImmutable(List<LoaderValues> valuesList) {
        HashMap effValues = new HashMap();
        for (LoaderValues lvs : valuesList) {
            for (ValidatedValue pv : lvs.getValues()) {
                effValues.putIfAbsent(pv.getProperty(), pv.getValue());
            }
        }
        return new ValidatedValuesImmutable(effValues);
    }
}

