/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.export.ManualExportAllowed;
import org.yarnandtail.andhow.export.ManualExportNotAllowed;
import org.yarnandtail.andhow.export.PropertyExport;
import org.yarnandtail.andhow.internal.NameAndProperty;
import org.yarnandtail.andhow.internal.export.PropertyExportImpl;

public class ManualExportService {
    Class<?>[] DISALLOW_EXPORT_ANNOTATIONS = new Class[]{ManualExportNotAllowed.class};

    public Stream<PropertyExport> doManualExport(List<Class<?>> exportRoots, Collection<GroupProxy> groupList) throws IllegalAccessException {
        HashSet alreadyExportedClasses = new HashSet();
        ArrayList<PropertyExport> propExports = new ArrayList<PropertyExport>();
        for (Class<?> clazz : exportRoots) {
            Optional<ManualExportAllowed> allow = this.findEffectiveAllowAnnotation(clazz);
            if (!allow.isPresent()) {
                throw new IllegalAccessException("The class '" + clazz + "' is not annotated to allow manual export. To export this class, annotate it with @" + ManualExportAllowed.class.getCanonicalName());
            }
            this.exportClassAndChildren(clazz, allow.get().useCanonicalName(), allow.get().useOutAliases(), alreadyExportedClasses, groupList, propExports);
        }
        return propExports.stream();
    }

    protected void exportClassAndChildren(Class<?> clazz, Exporter.EXPORT_CANONICAL_NAME canonicalOption, Exporter.EXPORT_OUT_ALIASES outAliasOption, Set<Class<?>> alreadyExportedClasses, Collection<GroupProxy> groupList, Collection<PropertyExport> propExports) {
        if (alreadyExportedClasses.contains(clazz)) {
            return;
        }
        this.exportClass(clazz, canonicalOption, outAliasOption, groupList, propExports);
        alreadyExportedClasses.add(clazz);
        for (Class<?> inner : clazz.getDeclaredClasses()) {
            if (this.isManualExportDisallowed(inner)) continue;
            Optional<ManualExportAllowed> mea = this.getAllowAnnotation(inner);
            if (mea.isPresent()) {
                this.exportClassAndChildren(inner, mea.get().useCanonicalName(), mea.get().useOutAliases(), alreadyExportedClasses, groupList, propExports);
                continue;
            }
            this.exportClassAndChildren(inner, canonicalOption, outAliasOption, alreadyExportedClasses, groupList, propExports);
        }
    }

    protected void exportClass(Class<?> clazz, Exporter.EXPORT_CANONICAL_NAME canNameOpt, Exporter.EXPORT_OUT_ALIASES outAliasOpt, Collection<GroupProxy> groupList, Collection<PropertyExport> propExports) {
        Optional<GroupProxy> proxy = groupList.stream().filter(g -> g.getProxiedGroup().equals(clazz)).findFirst();
        if (proxy.isPresent()) {
            for (NameAndProperty nap : proxy.get().getProperties()) {
                propExports.add(new PropertyExportImpl(nap.property, clazz, canNameOpt, outAliasOpt));
            }
        }
    }

    protected Optional<ManualExportAllowed> findEffectiveAllowAnnotation(Class<?> clazz) throws IllegalStateException {
        Optional<Object> allow = Optional.empty();
        Optional<Object> disallow = Optional.empty();
        if (clazz.isAnnotationPresent(ManualExportAllowed.class)) {
            allow = this.getAllowAnnotation(clazz);
        }
        if (this.isManualExportDisallowed(clazz)) {
            disallow = Optional.of(true);
        }
        if (allow.isPresent() && disallow.isPresent()) {
            throw new IllegalStateException("A class cannot be annotated with both a '" + ManualExportAllowed.class.getCanonicalName() + "' annotation and a disallow annotation.");
        }
        if (allow.isPresent() || disallow.isPresent()) {
            return allow;
        }
        if (clazz.getDeclaringClass() != null) {
            return this.findEffectiveAllowAnnotation(clazz.getDeclaringClass());
        }
        return allow;
    }

    protected Optional<ManualExportAllowed> getAllowAnnotation(Class<?> clazz) {
        return Optional.ofNullable(clazz.getAnnotation(ManualExportAllowed.class));
    }

    protected boolean isManualExportDisallowed(Class<?> clazz) {
        for (Class<?> da : this.DISALLOW_EXPORT_ANNOTATIONS) {
            if (!clazz.isAnnotationPresent(da)) continue;
            return true;
        }
        return false;
    }
}

