/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal.export;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.export.PropertyExport;

public class PropertyExportImpl
implements PropertyExport {
    private final Property<?> property;
    private final Class<?> containingClass;
    private final Exporter.EXPORT_CANONICAL_NAME canNameOpt;
    private final Exporter.EXPORT_OUT_ALIASES aliasOpt;

    public PropertyExportImpl(Property<?> property, Class<?> containingClass, Exporter.EXPORT_CANONICAL_NAME canonicalNameOpt, Exporter.EXPORT_OUT_ALIASES outAliasOpt) {
        this.property = property;
        this.containingClass = containingClass;
        this.canNameOpt = canonicalNameOpt;
        this.aliasOpt = outAliasOpt;
    }

    @Override
    public Property<?> getProperty() {
        return this.property;
    }

    @Override
    public Class<?> getContainingClass() {
        return this.containingClass;
    }

    @Override
    public Exporter.EXPORT_CANONICAL_NAME getCanonicalNameOption() {
        return this.canNameOpt;
    }

    @Override
    public Exporter.EXPORT_OUT_ALIASES getOutAliasOption() {
        return this.aliasOpt;
    }

    @Override
    public List<String> getExportNames() {
        return this.buildExportNames();
    }

    @Override
    public Object getValue() {
        return this.property.getValue();
    }

    @Override
    public String getValueAsString() {
        return this.property.getValueAsString();
    }

    @Override
    public PropertyExport mapNames(List<String> exportNames) {
        return PropertyExportImpl.mapNames(exportNames, this);
    }

    @Override
    public PropertyExport mapValue(Object value) {
        return PropertyExportImpl.mapValue(value, this);
    }

    @Override
    public PropertyExport mapValueAsString(String value) {
        return PropertyExportImpl.mapValueAsString(value, this);
    }

    protected List<String> buildExportNames() {
        ArrayList<String> names = new ArrayList<String>(1);
        List<String> aliasNames = this.property.getOutAliases();
        if (this.aliasOpt.equals((Object)Exporter.EXPORT_OUT_ALIASES.ALWAYS)) {
            names.addAll(aliasNames);
        }
        if (this.canNameOpt.equals((Object)Exporter.EXPORT_CANONICAL_NAME.ALWAYS) || this.canNameOpt.equals((Object)Exporter.EXPORT_CANONICAL_NAME.ONLY_IF_NO_OUT_ALIAS) && aliasNames.isEmpty()) {
            names.add(this.property.getCanonicalName());
        }
        return names;
    }

    protected static PropertyExport mapNames(final List<String> exportNames, PropertyExport inner) {
        return new PropertyExportWrap(inner){

            @Override
            public List<String> getExportNames() {
                return exportNames;
            }
        };
    }

    protected static PropertyExport mapValue(final Object value, PropertyExport inner) {
        return new PropertyExportWrap(inner){

            @Override
            public Object getValue() {
                return value;
            }
        };
    }

    protected static PropertyExport mapValueAsString(final String value, PropertyExport inner) {
        return new PropertyExportWrap(inner){

            @Override
            public String getValueAsString() {
                return value;
            }
        };
    }

    protected static class PropertyExportWrap
    implements PropertyExport {
        private final PropertyExport inner;

        public PropertyExportWrap(PropertyExport inner) {
            this.inner = inner;
        }

        @Override
        public Property<?> getProperty() {
            return this.inner.getProperty();
        }

        @Override
        public Class<?> getContainingClass() {
            return this.inner.getContainingClass();
        }

        @Override
        public Exporter.EXPORT_CANONICAL_NAME getCanonicalNameOption() {
            return this.inner.getCanonicalNameOption();
        }

        @Override
        public Exporter.EXPORT_OUT_ALIASES getOutAliasOption() {
            return this.inner.getOutAliasOption();
        }

        @Override
        public List<String> getExportNames() {
            return this.inner.getExportNames();
        }

        @Override
        public Object getValue() {
            return this.inner.getValue();
        }

        @Override
        public String getValueAsString() {
            return this.inner.getValueAsString();
        }

        @Override
        public PropertyExport mapNames(List<String> exportNames) {
            return PropertyExportImpl.mapNames(exportNames, this);
        }

        @Override
        public PropertyExport mapValue(Object value) {
            return PropertyExportImpl.mapValue(value, this);
        }

        @Override
        public PropertyExport mapValueAsString(String value) {
            return PropertyExportImpl.mapValueAsString(value, this);
        }
    }
}

