/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.LocalFileLoader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.load.LoaderException;
import org.yarnandtail.andhow.sample.PropFileLoaderSamplePrinter;

public abstract class PropFileBaseLoader
extends BaseLoader
implements ReadLoader,
LocalFileLoader {
    protected Property<String> pathProp;
    protected String pathStr;
    protected boolean missingFileAProblem = true;
    protected boolean unknownPropertyAProblem = true;

    public LoaderValues loadInputStreamToProps(InputStream inputStream, String fromPath, PropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues) throws LoaderException {
        if (inputStream == null) {
            IllegalArgumentException e = new IllegalArgumentException("The InputStream cannot be null");
            throw new LoaderException(e, this, "properties file at '" + fromPath + "'");
        }
        try {
            Properties props = new Properties();
            props.load(inputStream);
            ArrayList<ValidatedValue> values = new ArrayList<ValidatedValue>();
            ProblemList<Problem> problems = new ProblemList<Problem>();
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                if (key == null) continue;
                String k = key.toString();
                String v = props.getProperty(k);
                this.attemptToAdd(appConfigDef, values, problems, k, v);
            }
            values.trimToSize();
            return new LoaderValues(this, values, problems);
        }
        catch (Exception e) {
            throw new LoaderException(e, this, "properties file at '" + fromPath + "'");
        }
    }

    protected String getEffectivePath(ValidatedValuesWithContext existingValues) {
        if (this.pathStr != null) {
            return this.pathStr;
        }
        if (this.pathProp != null) {
            if (existingValues != null) {
                return existingValues.getValue(this.pathProp);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<Property> getInstanceConfig() {
        if (this.pathProp != null) {
            ArrayList<Property> list = new ArrayList<Property>();
            list.add(this.pathProp);
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return true;
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return new PropFileLoaderSamplePrinter();
    }

    @Override
    public String getLoaderType() {
        return "PropertyFile";
    }

    @Override
    public String getLoaderDialect() {
        return "KeyValuePair";
    }

    @Override
    public void setUnknownPropertyAProblem(boolean isAProblem) {
        this.unknownPropertyAProblem = isAProblem;
    }

    @Override
    public boolean isUnknownPropertyAProblem() {
        return this.unknownPropertyAProblem;
    }

    @Override
    public void setMissingFileAProblem(boolean isAProblem) {
        this.missingFileAProblem = isAProblem;
    }

    @Override
    public boolean isMissingFileAProblem() {
        return this.missingFileAProblem;
    }

    @Override
    public void setFilePath(String path) {
        if (path != null && this.pathProp != null) {
            throw new IllegalArgumentException("The FilePath cannot be specified as both a String and StrProp");
        }
        this.pathStr = path;
    }

    @Override
    public void setFilePath(Property<String> path) {
        if (path != null && this.pathStr != null) {
            throw new IllegalArgumentException("The FilePath cannot be specified as both a String and StrProp");
        }
        this.pathProp = path;
    }
}

