/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.io.IOException;
import java.io.InputStream;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.load.LoaderException;
import org.yarnandtail.andhow.load.PropFileBaseLoader;

public class PropFileOnClasspathLoader
extends PropFileBaseLoader {
    String specificLoadDescription = null;

    @Override
    public LoaderValues load(PropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues) {
        String path = this.getEffectivePath(existingValues);
        if (path != null) {
            this.specificLoadDescription = "file on classpath at: " + path;
            LoaderValues vals = this.load(appConfigDef, existingValues, path);
            return vals;
        }
        this.specificLoadDescription = "unpsecified file on classpath";
        return new LoaderValues(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoaderValues load(PropertyConfigurationInternal appConfigDef, ValidatedValuesWithContext existingValues, String path) {
        try (InputStream inS = PropFileOnClasspathLoader.class.getResourceAsStream(path);){
            if (inS != null) {
                LoaderValues loaderValues = this.loadInputStreamToProps(inS, path, appConfigDef, existingValues);
                return loaderValues;
            }
            if (this.isMissingFileAProblem()) {
                LoaderValues loaderValues = new LoaderValues(this, new LoaderProblem.SourceNotFoundLoaderProblem(this, "Expected file at classpath:" + path));
                return loaderValues;
            }
            LoaderValues loaderValues = new LoaderValues(this);
            return loaderValues;
        }
        catch (LoaderException e) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, e.getCause(), "classpath:" + path));
        }
        catch (IOException ioe) {
            return new LoaderValues(this, new LoaderProblem.IOLoaderProblem(this, ioe, "classpath:" + path));
        }
    }

    @Override
    public String getSpecificLoadDescription() {
        if (this.specificLoadDescription != null) {
            return this.specificLoadDescription;
        }
        String path = this.getEffectivePath(null);
        if (path != null) {
            return "file on classpath at: " + path;
        }
        return "unconfigured classpath";
    }
}

