/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;
import org.yarnandtail.andhow.sample.BaseSamplePrinter;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.sample.PropFileFormat;
import org.yarnandtail.andhow.sample.TextBlock;
import org.yarnandtail.andhow.util.TextUtil;
import org.yarnandtail.andhow.valuetype.FlagType;

public class PropFileLoaderSamplePrinter
extends BaseSamplePrinter
implements SamplePrinter {
    protected PrintFormat format = new PropFileFormat();

    @Override
    public PrintFormat getFormat() {
        return this.format;
    }

    @Override
    public TextBlock getSampleFileStart() {
        return null;
    }

    @Override
    public TextBlock getSampleStartComment(PropertyConfigurationInternal definition) {
        TextBlock tb = new TextBlock(true, true);
        tb.addHR();
        tb.addLine("Sample properties file generated by AndHow!");
        tb.addLine("strong.simple.valid.AppConfiguration  -  https://github.com/eeverman/andhow");
        tb.addLine("Note: " + definition.getNamingStrategy().getNameMatchingDescription());
        tb.addHR();
        return tb;
    }

    @Override
    public String getInAliaseString(PropertyConfigurationInternal definition, EffectiveName name) {
        return name.getActualName();
    }

    @Override
    public TextBlock getActualProperty(PropertyConfigurationInternal definition, GroupProxy group, Property prop) throws Exception {
        String propCanonName = group.getCanonicalName(prop);
        TextBlock tb = !(prop.getValueType() instanceof FlagType) ? new TextBlock(false, false) : new TextBlock(false, true);
        tb.addLine(TextUtil.format("{} = ", propCanonName));
        return tb;
    }

    @Override
    public TextBlock getSampleFileEnd() {
        return null;
    }

    @Override
    public String getSampleFileExtension() {
        return "properties";
    }
}

