/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.sample;

import java.util.ArrayList;
import java.util.List;
import org.yarnandtail.andhow.sample.PrintFormat;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class TextLine {
    protected Boolean wrap;

    abstract String getLine(PrintFormat var1);

    abstract String getLineComment(PrintFormat var1);

    abstract String getBlockComment(PrintFormat var1, boolean var2, boolean var3);

    abstract List<String> getWrappedLine(PrintFormat var1);

    abstract List<String> getWrappedLineComment(PrintFormat var1);

    abstract List<String> getWrappedBlockComment(PrintFormat var1, boolean var2, boolean var3);

    public static class BlankLine
    extends TextLine {
        public BlankLine() {
            this.wrap = false;
        }

        @Override
        public String getLine(PrintFormat format) {
            return "";
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator) + "";
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = "";
            if (startComment && format.blockCommentStart != null) {
                out = format.blockCommentStart + TextUtil.nullToEmpty(format.blockCommentSeparator) + out;
            }
            if (endComment && format.blockCommentEnd != null) {
                out = out + TextUtil.nullToEmpty(format.blockCommentSeparator) + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            return lines;
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator) + "");
            return lines;
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            ArrayList<String> lines = new ArrayList<String>();
            String out = "";
            if (startComment && format.blockCommentStart != null) {
                out = out + format.blockCommentStart + TextUtil.nullToEmpty(format.blockCommentSeparator);
            }
            if (endComment && format.blockCommentSeparator != null) {
                out = out + format.blockCommentSeparator + TextUtil.nullToEmpty(format.blockCommentEnd);
            }
            lines.add(out);
            return lines;
        }
    }

    public static class HRLine
    extends TextLine {
        public HRLine() {
            this.wrap = false;
        }

        @Override
        public String getLine(PrintFormat format) {
            return format.hr;
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator) + format.hr;
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = format.hr;
            if (startComment && format.blockCommentStart != null) {
                out = format.blockCommentStart + TextUtil.nullToEmpty(format.blockCommentSeparator) + out;
            }
            if (endComment && format.blockCommentEnd != null) {
                out = out + TextUtil.nullToEmpty(format.blockCommentSeparator) + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(format.hr);
            return lines;
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator) + format.hr);
            return lines;
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.getBlockComment(format, startComment, endComment));
            return lines;
        }
    }

    public static class StringLine
    extends TextLine {
        String line;

        public StringLine(String line, boolean wrap) {
            this.line = line;
            this.wrap = wrap;
        }

        public StringLine(String line) {
            this.line = line;
            this.wrap = null;
        }

        @Override
        public String getLine(PrintFormat format) {
            return this.line;
        }

        @Override
        public String getLineComment(PrintFormat format) {
            return TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator) + this.line;
        }

        @Override
        public String getBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            String out = this.line;
            if (startComment && format.blockCommentStart != null) {
                out = format.blockCommentStart + TextUtil.nullToEmpty(format.blockCommentSeparator) + out;
            }
            if (endComment && format.blockCommentEnd != null) {
                out = out + TextUtil.nullToEmpty(format.blockCommentSeparator) + format.blockCommentEnd;
            }
            return out;
        }

        @Override
        public List<String> getWrappedLine(PrintFormat format) {
            return TextUtil.wrap(this.line, format.lineWidth, "", format.secondLineIndent);
        }

        @Override
        public List<String> getWrappedLineComment(PrintFormat format) {
            return TextUtil.wrap(this.line, format.lineWidth, TextUtil.nullToEmpty(format.lineCommentPrefix) + TextUtil.nullToEmpty(format.lineCommentPrefixSeparator), format.secondLineIndent);
        }

        @Override
        public List<String> getWrappedBlockComment(PrintFormat format, boolean startComment, boolean endComment) {
            List<String> lines = TextUtil.wrap(this.line, format.lineWidth, "", format.secondLineIndent);
            if (startComment && endComment && lines.size() == 1) {
                lines.set(0, TextUtil.nullToEmpty(format.blockCommentStart) + TextUtil.nullToEmpty(format.blockCommentSeparator) + lines.get(0) + TextUtil.nullToEmpty(format.blockCommentSeparator) + TextUtil.nullToEmpty(format.blockCommentEnd));
            } else {
                if (startComment && format.blockCommentStart != null) {
                    lines.add(0, format.blockCommentStart);
                }
                if (endComment && format.blockCommentEnd != null) {
                    lines.set(lines.size() - 1, lines.get(lines.size() - 1) + TextUtil.nullToEmpty(format.blockCommentSeparator) + format.blockCommentEnd);
                }
            }
            return lines;
        }
    }
}

