/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.GroupProxyMutable;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.NameAndProperty;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.service.PropertyRegistration;

public class PropertyRegistrarLoader {
    private final ClassLoader classLoader;
    private final ServiceLoader<PropertyRegistrar> loader;
    private final Object lock = new Object();

    public PropertyRegistrarLoader() {
        this(PropertyRegistrarLoader.class.getClassLoader());
    }

    public PropertyRegistrarLoader(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : PropertyRegistrarLoader.class.getClassLoader();
        this.loader = ServiceLoader.load(PropertyRegistrar.class, this.classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyRegistrar> getPropertyRegistrars() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<PropertyRegistrar> list = new ArrayList<PropertyRegistrar>();
            Iterator<PropertyRegistrar> it = this.loader.iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
    }

    public List<GroupProxy> getGroups() {
        LinkedHashMap<String, GroupProxyMutable> groups = new LinkedHashMap<String, GroupProxyMutable>();
        List<PropertyRegistrar> registrars = this.getPropertyRegistrars();
        for (PropertyRegistrar registrar : registrars) {
            for (PropertyRegistration registration : registrar.getRegistrationList()) {
                String grpName = registration.getCanonicalParentName();
                GroupProxyMutable grp = (GroupProxyMutable)groups.get(grpName);
                if (grp == null) {
                    grp = new GroupProxyMutable(registration.getCanonicalParentName(), registration.getJavaCanonicalParentName());
                    groups.put(grpName, grp);
                }
                Class<?> group = null;
                Property prop = null;
                try {
                    group = Class.forName(registration.getJavaCanonicalParentName());
                    Field f = group.getDeclaredField(registration.getPropertyName());
                    try {
                        prop = (Property)f.get(null);
                    }
                    catch (Exception ex) {
                        f.setAccessible(true);
                        prop = (Property)f.get(null);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    Logger.getLogger(PropertyRegistrarLoader.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (SecurityException ex) {
                    Logger.getLogger(PropertyRegistrarLoader.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(PropertyRegistrarLoader.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                NameAndProperty nap = new NameAndProperty(registration.getPropertyName(), prop);
                grp.addProperty(nap);
            }
        }
        ArrayList<GroupProxy> list = new ArrayList<GroupProxy>();
        list.addAll(groups.values());
        return list;
    }
}

