/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.AndHowConfiguration;
import org.yarnandtail.andhow.GroupExport;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.GroupProxyImmutable;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.NameAndProperty;
import org.yarnandtail.andhow.internal.PropertyConfigurationMutable;
import org.yarnandtail.andhow.service.InitLoader;
import org.yarnandtail.andhow.service.TestInitLoader;
import org.yarnandtail.andhow.util.NameUtil;

public class AndHowUtil {
    public static PropertyConfigurationMutable buildDefinition(List<GroupProxy> groups, List<Loader> loaders, NamingStrategy naming, ProblemList<Problem> problems) {
        ConstructionProblem ee;
        PropertyConfigurationMutable appDef = new PropertyConfigurationMutable(naming);
        if (groups != null) {
            for (GroupProxy group : groups) {
                problems.addAll(AndHowUtil.registerGroup(appDef, group));
                try {
                    List<Exporter> exps = AndHowUtil.getExporters(group);
                    for (Exporter e : exps) {
                        ExportGroup eg = new ExportGroup(e, group);
                        appDef.addExportGroup(eg);
                    }
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    ee = new ConstructionProblem.ExportException(ex, group, "Unable to created a new instance of one of the Exporters for this group.  Do they all have zero argument constructors?");
                    problems.add(ee);
                }
                catch (IllegalAccessException ex) {
                    ConstructionProblem.SecurityException se = new ConstructionProblem.SecurityException(ex, group.getProxiedGroup());
                    problems.add(se);
                }
            }
        }
        if (loaders != null) {
            for (Loader loader : loaders) {
                if (loader.getClassConfig() != null) {
                    try {
                        problems.addAll(AndHowUtil.registerGroup(appDef, AndHowUtil.buildGroupProxy(loader.getClassConfig(), false)));
                    }
                    catch (Exception ex) {
                        ee = new ConstructionProblem.SecurityException(ex, loader.getClassConfig());
                        problems.add(ee);
                    }
                }
                for (Property p : loader.getInstanceConfig()) {
                    if (p == null) {
                        problems.add(new ConstructionProblem.LoaderPropertyIsNull(loader));
                        continue;
                    }
                    if (appDef.getCanonicalName(p) != null) continue;
                    problems.add(new ConstructionProblem.LoaderPropertyNotRegistered(loader, p));
                }
            }
        }
        return appDef;
    }

    protected static ProblemList<ConstructionProblem> registerGroup(PropertyConfigurationMutable appDef, GroupProxy group) {
        ProblemList<ConstructionProblem> problems = new ProblemList<ConstructionProblem>();
        try {
            List<NameAndProperty> nameAndProperties = group.getProperties();
            for (NameAndProperty nameAndProp : nameAndProperties) {
                problems.add(appDef.addProperty(group, nameAndProp.property));
            }
        }
        catch (Exception ex) {
            ConstructionProblem.SecurityException se = new ConstructionProblem.SecurityException(ex, group.getProxiedGroup());
            problems.add(se);
        }
        return problems;
    }

    public static AppFatalException buildFatalException(ProblemList<Problem> problems) {
        return new AppFatalException("Unable to complete application configuration due to problems. See the System.err out or the log files for complete details.", problems);
    }

    public static List<Exporter> getExporters(GroupProxy group) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        GroupExport[] groupExports;
        ArrayList<Exporter> exps = new ArrayList<Exporter>();
        for (GroupExport ge : groupExports = (GroupExport[])group.getProxiedGroup().getAnnotationsByType(GroupExport.class)) {
            Class<? extends Exporter> expClass = ge.exporter();
            Exporter exporter = expClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exporter.setExportByCanonicalName(ge.exportByCanonicalName());
            exporter.setExportByOutAliases(ge.exportByOutAliases());
            exps.add(exporter);
        }
        exps.trimToSize();
        return Collections.unmodifiableList(exps);
    }

    public static List<NameAndProperty> getProperties(Class<?> group) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        ArrayList<NameAndProperty> props = new ArrayList<NameAndProperty>();
        for (Field f : fields = group.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Property.class.isAssignableFrom(f.getType())) continue;
            Property cp = null;
            try {
                cp = (Property)f.get(null);
            }
            catch (Exception ex) {
                f.setAccessible(true);
                cp = (Property)f.get(null);
            }
            props.add(new NameAndProperty(f.getName(), cp));
        }
        return props;
    }

    public static GroupProxy buildGroupProxy(Class<?> group) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        return AndHowUtil.buildGroupProxy(group, true);
    }

    public static GroupProxy buildGroupProxy(Class<?> group, boolean userGroup) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        List<NameAndProperty> naps = AndHowUtil.getProperties(group);
        GroupProxyImmutable groupProxy = new GroupProxyImmutable(NameUtil.getAndHowName(group), NameUtil.getJavaName(group), naps, userGroup);
        return groupProxy;
    }

    public static List<GroupProxy> buildGroupProxies(Collection<Class<?>> registeredGroups) throws AppFatalException {
        ProblemList<Problem> problems = new ProblemList<Problem>();
        ArrayList<GroupProxy> groupProxies = new ArrayList<GroupProxy>();
        for (Class<?> clazz : registeredGroups) {
            try {
                GroupProxy gp = AndHowUtil.buildGroupProxy(clazz);
                groupProxies.add(gp);
            }
            catch (Exception ex) {
                problems.add(new ConstructionProblem.SecurityException(ex, clazz));
            }
        }
        if (problems.isEmpty()) {
            return groupProxies;
        }
        AppFatalException afe = new AppFatalException("There is a problem converting the AndHow Properties contained in the registered groups - likely this is a security issue.", problems);
        throw afe;
    }

    public static String getFieldName(Class<?> group, Property<?> property) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        for (Field f : fields = group.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Property.class.isAssignableFrom(f.getType())) continue;
            Property cp = null;
            try {
                cp = (Property)f.get(null);
            }
            catch (Exception ex) {
                f.setAccessible(true);
                cp = (Property)f.get(null);
            }
            if (!cp.equals(property)) continue;
            return f.getName();
        }
        return null;
    }

    public static Method findMethod(Class<?> target, String name, Class<?> ... parameterTypes) throws SecurityException {
        while (target != null) {
            try {
                Method m = target.getDeclaredMethod(name, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                target = target.getSuperclass();
            }
        }
        return null;
    }

    public static boolean classExists(String className) {
        return AndHowUtil.getClassForName(className) != null;
    }

    public static Class<?> getClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Object getClassInstanceForName(String className) {
        Class<?> c = AndHowUtil.getClassForName(className);
        if (c != null) {
            try {
                return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static AndHowConfiguration<? extends AndHowConfiguration> findConfiguration(AndHowConfiguration<? extends AndHowConfiguration> defaultConfig) throws AppFatalException {
        InitLoader prodLoader = new InitLoader();
        TestInitLoader testLoader = new TestInitLoader();
        if (!prodLoader.isValidState()) {
            throw new AppFatalException("Unexpected multiple AndHowInit classes on the classpath", new ConstructionProblem.TooManyAndHowInitInstances(prodLoader.getInitInstances()));
        }
        if (testLoader != null && !((InitLoader)testLoader).isValidState()) {
            throw new AppFatalException("Unexpected multiple AndHowTestInit classes on the classpath", new ConstructionProblem.TooManyAndHowInitInstances(((InitLoader)testLoader).getInitInstances()));
        }
        if (testLoader != null && ((InitLoader)testLoader).hasConfig()) {
            return ((InitLoader)testLoader).getAndHowConfiguration(defaultConfig);
        }
        return prodLoader.getAndHowConfiguration(defaultConfig);
    }
}

