/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class IOUtil {
    private static final String JAVA_TMP_KEY = "java.io.tmpdir";

    private IOUtil() {
    }

    public static String getUTF8ResourceAsString(String path) throws IOException {
        InputStream in = IOUtil.class.getResourceAsStream(path);
        if (in == null) {
            throw new IOException("Unable to find the resource '" + path + "'");
        }
        return IOUtil.toString(in, Charset.forName("UTF-8"));
    }

    public static String getResourceAsString(String path, Charset encoding) throws IOException {
        InputStream in = IOUtil.class.getResourceAsStream(path);
        if (in == null) {
            throw new IOException("Unable to find the resource '" + path + "'");
        }
        return IOUtil.toString(in, encoding);
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, encoding));){
            String line = reader.readLine();
            while (line != null) {
                builder.append(line).append(System.lineSeparator());
                line = reader.readLine();
            }
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - System.lineSeparator().length());
        }
        return builder.toString();
    }

    public static String expandDirectoryPath(String path) {
        if (!(path = IOUtil.expandFilePath(path)).endsWith(String.valueOf(File.separatorChar))) {
            return path + File.separatorChar;
        }
        return path;
    }

    public static String expandFilePath(String path) {
        String tmpDir = System.getProperty(JAVA_TMP_KEY);
        if ((path = path.trim()).length() > JAVA_TMP_KEY.length() && tmpDir.endsWith(System.getProperty("file.separator"))) {
            tmpDir = tmpDir.substring(0, tmpDir.length() - 1);
        }
        path = path.replace(JAVA_TMP_KEY, tmpDir);
        path = path.replace('/', System.getProperty("file.separator").charAt(0));
        return path;
    }
}

