/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.yarnandtail.andhow.BaseConfig;
import org.yarnandtail.andhow.PropertyValue;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.StandardLoader;
import org.yarnandtail.andhow.load.KeyObjectPair;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.util.TextUtil;

public class StdConfig {
    public static StdConfigImpl instance() {
        return new StdConfigImpl();
    }

    public static abstract class StdConfigAbstract<S extends StdConfigAbstract<S>>
    extends BaseConfig<S> {
        @Override
        public <T> S addFixedValue(Property<T> property, T value) {
            if (property == null) {
                throw new IllegalArgumentException("The property cannot be null");
            }
            for (PropertyValue pv : this._fixedVals) {
                if (!property.equals(pv.getProperty())) continue;
                throw new IllegalArgumentException("A fixed value for this property has been assigned twice.");
            }
            PropertyValue<T> pv = new PropertyValue<T>(property, value);
            this._fixedVals.add(pv);
            return (S)this;
        }

        @Override
        public S removeFixedValue(Property<?> property) {
            this._fixedVals.removeIf(f -> f.getProperty().equals(property));
            return (S)this;
        }

        @Override
        public S addFixedValue(String propertyNameOrAlias, Object value) {
            try {
                KeyObjectPair kop = new KeyObjectPair(propertyNameOrAlias, value);
                if (this._fixedKeyObjectPairVals.stream().map(k -> k.getName()).anyMatch(n -> n.equals(kop.getName()))) {
                    throw new IllegalArgumentException("A fixed value for the Property '" + kop.getName() + "' has been assigned twice.");
                }
                this._fixedKeyObjectPairVals.add(kop);
                return (S)this;
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public S removeFixedValue(String propertyNameOrAlias) {
            String cleanName = TextUtil.trimToNull(propertyNameOrAlias);
            this._fixedKeyObjectPairVals.removeIf(k -> k.getName().equals(cleanName));
            return (S)this;
        }

        @Override
        public S setCmdLineArgs(String[] commandLineArgs) {
            this._cmdLineArgs.clear();
            if (commandLineArgs != null && commandLineArgs.length > 0) {
                this._cmdLineArgs.addAll(Arrays.asList(commandLineArgs));
            }
            return (S)this;
        }

        @Override
        public S setClasspathPropFilePath(String classpathPropFilePathString) {
            if ((classpathPropFilePathString = TextUtil.trimToNull(classpathPropFilePathString)) != null && this.classpathPropFilePathProp != null) {
                throw new IllegalArgumentException("The property file classpath cannot be specified as both a String and StrProp");
            }
            if (classpathPropFilePathString != null && classpathPropFilePathString.contains(".") && !classpathPropFilePathString.startsWith("/")) {
                throw new IllegalArgumentException("A path to a property file on the classpath must start with a '/' if the filename contains a dot.");
            }
            this.classpathPropFilePathStr = classpathPropFilePathString;
            return (S)this;
        }

        @Override
        public S setClasspathPropFilePath(StrProp classpathPropFilePathProperty) {
            if (this.classpathPropFilePathStr != null && classpathPropFilePathProperty != null) {
                throw new IllegalArgumentException("The property file classpath cannot be specified as both a String and StrProp");
            }
            this.classpathPropFilePathProp = classpathPropFilePathProperty;
            return (S)this;
        }

        @Override
        public S classpathPropertiesRequired() {
            this._missingClasspathPropFileAProblem = true;
            return (S)this;
        }

        @Override
        public S classpathPropertiesNotRequired() {
            this._missingClasspathPropFileAProblem = false;
            return (S)this;
        }

        @Override
        public S setFilesystemPropFilePath(StrProp filesystemPropFilePath) {
            this.filesystemPropFilePathProp = filesystemPropFilePath;
            return (S)this;
        }

        @Override
        public S filesystemPropFileRequired() {
            this._missingFilesystemPropFileAProblem = true;
            return (S)this;
        }

        @Override
        public S filesystemPropFileNotRequired() {
            this._missingFilesystemPropFileAProblem = false;
            return (S)this;
        }

        @Deprecated
        public S setSystemProperties(Properties properties) {
            this.systemProperties = properties;
            return (S)this;
        }

        @Deprecated
        public S setEnvironmentProperties(Map<String, String> newEnvProperties) {
            if (newEnvProperties != null) {
                this.envProperties = new HashMap();
                this.envProperties.putAll(newEnvProperties);
            } else {
                this.envProperties = null;
            }
            return (S)this;
        }

        @Override
        public S setStandardLoaders(List<Class<? extends StandardLoader>> newStandardLoaders) {
            this.standardLoaders.clear();
            this.standardLoaders.addAll(newStandardLoaders);
            return (S)this;
        }

        @Override
        public S setStandardLoaders(Class<? extends StandardLoader> ... newStandardLoaders) {
            this.standardLoaders.clear();
            for (Class<? extends StandardLoader> sl : newStandardLoaders) {
                this.standardLoaders.add(sl);
            }
            return (S)this;
        }

        @Override
        public S insertLoaderBefore(Class<? extends StandardLoader> insertBeforeThisLoader, Loader loaderToInsert) {
            if (this.insertBefore.containsKey(insertBeforeThisLoader)) {
                ((List)this.insertBefore.get(insertBeforeThisLoader)).add(loaderToInsert);
            } else {
                ArrayList<Loader> list = new ArrayList<Loader>(1);
                list.add(loaderToInsert);
                this.insertBefore.put(insertBeforeThisLoader, list);
            }
            return (S)this;
        }

        @Override
        public S insertLoaderAfter(Class<? extends StandardLoader> insertAfterThisLoader, Loader loaderToInsert) {
            if (this.insertAfter.containsKey(insertAfterThisLoader)) {
                ((List)this.insertAfter.get(insertAfterThisLoader)).add(loaderToInsert);
            } else {
                ArrayList<Loader> list = new ArrayList<Loader>(1);
                list.add(loaderToInsert);
                this.insertAfter.put(insertAfterThisLoader, list);
            }
            return (S)this;
        }
    }

    public static final class StdConfigImpl
    extends StdConfigAbstract<StdConfigImpl> {
    }
}

