/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.yarnandtail.andhow.compile.CompileUnit;
import org.yarnandtail.andhow.compile.CompileUtil;
import org.yarnandtail.andhow.service.PropertyRegistrar;
import org.yarnandtail.andhow.service.PropertyRegistration;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.IOUtil;

public class PropertyRegistrarClassGenerator {
    protected static final String CLASS_TEMPLATE_PATH = "/org/yarnandtail/andhow/compile/PropertyRegistrarClassGenerator_ClassTemplate.txt";
    protected static final String ANNOTATION_TEMPLATE_PATH = "/org/yarnandtail/andhow/compile/PropertyRegistrarClassGenerator_AnnTemplate.txt";
    protected static final String COMMENTED_ANNOTATION_TEMPLATE_PATH = "/org/yarnandtail/andhow/compile/PropertyRegistrarClassGenerator_CommentedAnnTemplate.txt";
    private final CompileUnit compUnit;
    private final Class<?> generatingClass;
    private final Calendar runDate;
    private final SimpleDateFormat dateFormat;
    private final int srcMajorVersion;
    private final int jdkMajorVersion;

    public PropertyRegistrarClassGenerator(CompileUnit compUnit, Class<?> generatingClass, Calendar runDate, int srcMajorVersion, int jdkMajorVersion) {
        this.compUnit = compUnit;
        this.generatingClass = generatingClass;
        this.runDate = runDate;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.srcMajorVersion = srcMajorVersion;
        this.jdkMajorVersion = jdkMajorVersion;
    }

    public String getTemplate(String path) throws Exception {
        return IOUtil.getUTF8ResourceAsString(path);
    }

    public String generateAnnotationSource() throws Exception {
        boolean okToUseAnnotation = CompileUtil.isGeneratedVersionDeterministic(this.srcMajorVersion, this.jdkMajorVersion);
        String annotationTemplate = okToUseAnnotation ? this.getTemplate(ANNOTATION_TEMPLATE_PATH) : this.getTemplate(COMMENTED_ANNOTATION_TEMPLATE_PATH);
        String generatedAnnotation = String.format(annotationTemplate, CompileUtil.getGeneratedAnnotationClassName(this.jdkMajorVersion), this.generatingClass.getCanonicalName(), this.buildRunDateString(), this.compUnit.getRootCanonicalName(), PropertyRegistrar.class.getCanonicalName());
        return generatedAnnotation;
    }

    public String generateSource() throws Exception {
        String classTemplate = this.getTemplate(CLASS_TEMPLATE_PATH);
        String generatedAnnotation = this.generateAnnotationSource();
        String source = String.format(classTemplate, this.buildPackageString(), this.compUnit.getRootCanonicalName(), this.compUnit.getRootSimpleName(), this.buildGeneratedClassSimpleName(), generatedAnnotation, this.buildRegistrationAddsString(), this.jdkMajorVersion, this.srcMajorVersion);
        return source;
    }

    protected String buildPackageString() {
        if (this.compUnit.getRootPackageName() != null) {
            return "package " + this.compUnit.getRootPackageName() + ";";
        }
        return "";
    }

    protected String buildGeneratedClassSimpleName() {
        return "$" + this.compUnit.getRootSimpleName() + "_AndHowProps";
    }

    protected String buildGeneratedClassFullName() {
        if (this.compUnit.getRootPackageName() != null) {
            return this.compUnit.getRootPackageName() + "." + this.buildGeneratedClassSimpleName();
        }
        return this.buildGeneratedClassSimpleName();
    }

    protected String buildRunDateString() {
        return this.dateFormat.format(this.runDate.getTime());
    }

    protected String buildRegistrationAddsString() {
        StringBuilder buf = new StringBuilder();
        PropertyRegistrationList regList = this.compUnit.getRegistrations();
        regList.sort();
        PropertyRegistration prevReg = null;
        for (PropertyRegistration pr : regList) {
            if (prevReg != null && pr.compareInnerPathTo(prevReg) != 0 || prevReg == null && pr.getInnerPathLength() > 0) {
                buf.append("\t\tlist.add(\"").append(pr.getPropertyName()).append("\"");
                for (String step : pr.getInnerPath()) {
                    buf.append(", \"").append(step).append("\"");
                }
                buf.append(");").append(System.lineSeparator());
            } else {
                buf.append("\t\tlist.add(\"").append(pr.getPropertyName()).append("\");").append(System.lineSeparator());
            }
            prevReg = pr;
        }
        return buf.toString();
    }
}

