/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.GroupProxy;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyNaming;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.PropertyConfigurationImmutable;
import org.yarnandtail.andhow.internal.PropertyConfigurationInternal;

public class PropertyConfigurationMutable
implements PropertyConfigurationInternal {
    private final NamingStrategy namingStrategy;
    private final Map<GroupProxy, List<Property<?>>> propertiesByGroup = new HashMap();
    private final List<GroupProxy> groupList = new ArrayList<GroupProxy>();
    private final Map<Property<?>, List<EffectiveName>> aliasesByProperty = new HashMap();
    private final Map<String, Property<?>> propertiesByAnyName = new HashMap();
    private final Map<Property<?>, String> canonicalNameByProperty = new HashMap();
    private final List<Property<?>> properties = new ArrayList();
    private final List<ExportGroup> exportGroups = new ArrayList<ExportGroup>();
    private final HashMap<String, Property<?>> propertiesByExportName = new HashMap();

    public PropertyConfigurationMutable(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public ConstructionProblem addProperty(GroupProxy group, Property<?> property) {
        Property<?> conflictProp;
        PropertyNaming names = null;
        if (group == null || property == null) {
            throw new RuntimeException("Null values are not allowed when registering a property.");
        }
        try {
            names = this.namingStrategy.buildNames(property, group);
            if (names == null) {
                return new ConstructionProblem.PropertyNotPartOfGroup(group, property);
            }
        }
        catch (Exception ex) {
            return new ConstructionProblem.SecurityException(ex, group.getProxiedGroup());
        }
        this.aliasesByProperty.put(property, names.getAliases());
        ArrayList<EffectiveName> allInNames = new ArrayList<EffectiveName>();
        allInNames.add(names.getCanonicalName());
        allInNames.addAll(names.getInAliases());
        if (this.canonicalNameByProperty.containsKey(property)) {
            ConstructionProblem.DuplicateProperty dupProp = new ConstructionProblem.DuplicateProperty(this.getGroupForProperty(property), property, group, property);
            return dupProp;
        }
        for (EffectiveName effectiveName : allInNames) {
            conflictProp = this.propertiesByAnyName.get(effectiveName.getEffectiveInName());
            if (conflictProp == null) continue;
            ConstructionProblem.NonUniqueNames notUniqueName = new ConstructionProblem.NonUniqueNames(this.getGroupForProperty(conflictProp), conflictProp, group, property, effectiveName.getActualName());
            return notUniqueName;
        }
        for (EffectiveName effectiveName : names.getOutAliases()) {
            if (!this.propertiesByExportName.containsKey(effectiveName.getEffectiveOutName())) {
                this.propertiesByExportName.put(effectiveName.getEffectiveOutName(), property);
                continue;
            }
            conflictProp = this.propertiesByExportName.get(effectiveName.getActualName());
            ConstructionProblem.NonUniqueNames notUniqueName = new ConstructionProblem.NonUniqueNames(this.getGroupForProperty(conflictProp), conflictProp, group, property, effectiveName.getActualName());
            return notUniqueName;
        }
        for (Validator validator : property.getValidators()) {
            if (validator.isSpecificationValid()) continue;
            ConstructionProblem.InvalidValidationConfiguration badValid = new ConstructionProblem.InvalidValidationConfiguration(group, property, validator);
            return badValid;
        }
        ConstructionProblem.InvalidDefaultValue invalidDefault = this.checkForInvalidDefaultValue(property, group, names.getCanonicalName().getActualName());
        if (invalidDefault != null) {
            return invalidDefault;
        }
        this.canonicalNameByProperty.put(property, names.getCanonicalName().getActualName());
        this.properties.add(property);
        for (EffectiveName n : allInNames) {
            this.propertiesByAnyName.put(n.getEffectiveInName(), property);
        }
        List<Property<?>> list = this.propertiesByGroup.get(group);
        if (list != null) {
            list.add(property);
        } else {
            ArrayList arrayList = new ArrayList();
            arrayList.add(property);
            this.propertiesByGroup.put(group, arrayList);
            this.groupList.add(group);
        }
        return null;
    }

    public void addExportGroup(ExportGroup exportGroup) {
        this.exportGroups.add(exportGroup);
    }

    @Override
    public Property<?> getProperty(String classpathStyleName) {
        return this.propertiesByAnyName.get(this.namingStrategy.toEffectiveName(classpathStyleName));
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return this.aliasesByProperty.get(property);
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.canonicalNameByProperty.get(prop);
    }

    @Override
    public List<Property<?>> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public List<GroupProxy> getPropertyGroups() {
        return Collections.unmodifiableList(this.groupList);
    }

    @Override
    public boolean containsUserGroups() {
        for (GroupProxy g : this.getPropertyGroups()) {
            if (!g.isUserGroup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Property<?>> getPropertiesForGroup(GroupProxy group) {
        List<Property<?>> pts = this.propertiesByGroup.get(group);
        if (pts != null) {
            return Collections.unmodifiableList(pts);
        }
        return EMPTY_PROPERTY_LIST;
    }

    @Override
    public GroupProxy getGroupForProperty(Property<?> prop) {
        for (GroupProxy group : this.groupList) {
            if (!this.propertiesByGroup.get(group).contains(prop)) continue;
            return group;
        }
        return null;
    }

    @Override
    public List<ExportGroup> getExportGroups() {
        return Collections.unmodifiableList(this.exportGroups);
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    protected final <T> ConstructionProblem.InvalidDefaultValue checkForInvalidDefaultValue(Property<T> property, GroupProxy group, String canonName) {
        T t;
        if (property.getDefaultValue() != null && (t = property.getDefaultValue()) != null) {
            for (Validator<T> v : property.getValidators()) {
                if (v.isValid(t)) continue;
                ConstructionProblem.InvalidDefaultValue problem = new ConstructionProblem.InvalidDefaultValue(group, property, v.getInvalidMessage(t));
                return problem;
            }
        }
        return null;
    }

    public PropertyConfigurationInternal toImmutable() {
        return new PropertyConfigurationImmutable(this.namingStrategy, this.groupList, this.properties, this.propertiesByGroup, this.propertiesByAnyName, this.aliasesByProperty, this.canonicalNameByProperty, this.exportGroups);
    }
}

