/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.util.TextUtil;

public class KeyObjectPair {
    private String name;
    private Object value;

    public KeyObjectPair(String name) throws ParsingException {
        this(name, null);
    }

    public KeyObjectPair(String name, Object value) throws ParsingException {
        String cleanName = TextUtil.trimToNull(name);
        if (cleanName == null) {
            throw new ParsingException("The key (parameter name) cannot be empty or null", name);
        }
        this.name = cleanName;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + " : \"" + (this.value != null ? this.value.toString() : "[null]") + "\"";
    }
}

