/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.math.BigDecimal;
import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;
import org.yarnandtail.andhow.property.PropertyBase;
import org.yarnandtail.andhow.property.PropertyBuilderBase;
import org.yarnandtail.andhow.property.TrimToNullTrimmer;
import org.yarnandtail.andhow.valid.BigDecValidator;
import org.yarnandtail.andhow.valuetype.BigDecType;

public class BigDecProp
extends PropertyBase<BigDecimal> {
    public BigDecProp(BigDecimal defaultValue, boolean required, String shortDesc, List<Validator<BigDecimal>> validators, List<Name> aliases, PropertyType paramType, ValueType<BigDecimal> valueType, Trimmer trimmer, String helpText) {
        super(defaultValue, required, shortDesc, validators, aliases, paramType, valueType, trimmer, helpText);
    }

    public static BigDecBuilder builder() {
        return new BigDecBuilder();
    }

    public static class BigDecBuilder
    extends PropertyBuilderBase<BigDecBuilder, BigDecProp, BigDecimal> {
        public BigDecBuilder() {
            this.instance = this;
            this.valueType(BigDecType.instance());
            this.trimmer(TrimToNullTrimmer.instance());
        }

        @Override
        public BigDecProp build() {
            return new BigDecProp((BigDecimal)this._defaultValue, this._nonNull, this._desc, this._validators, (List<Name>)this._aliases, PropertyType.SINGLE_NAME_VALUE, this._valueType, this._trimmer, this._helpText);
        }

        @Deprecated
        public BigDecBuilder mustBeGreaterThan(BigDecimal reference) {
            return this.greaterThan(reference);
        }

        public BigDecBuilder greaterThan(BigDecimal reference) {
            this.validation(new BigDecValidator.GreaterThan(reference));
            return (BigDecBuilder)this.instance;
        }

        @Deprecated
        public BigDecBuilder mustBeGreaterThanOrEqualTo(BigDecimal reference) {
            return this.greaterThanOrEqualTo(reference);
        }

        public BigDecBuilder greaterThanOrEqualTo(BigDecimal reference) {
            this.validation(new BigDecValidator.GreaterThanOrEqualTo(reference));
            return (BigDecBuilder)this.instance;
        }

        @Deprecated
        public BigDecBuilder mustBeLessThan(BigDecimal reference) {
            return this.lessThan(reference);
        }

        public BigDecBuilder lessThan(BigDecimal reference) {
            this.validation(new BigDecValidator.LessThan(reference));
            return (BigDecBuilder)this.instance;
        }

        @Deprecated
        public BigDecBuilder mustBeLessThanOrEqualTo(BigDecimal reference) {
            return this.lessThanOrEqualTo(reference);
        }

        public BigDecBuilder lessThanOrEqualTo(BigDecimal reference) {
            this.validation(new BigDecValidator.LessThanOrEqualTo(reference));
            return (BigDecBuilder)this.instance;
        }
    }
}

