/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.property;

import java.util.List;
import org.yarnandtail.andhow.api.Name;
import org.yarnandtail.andhow.api.PropertyType;
import org.yarnandtail.andhow.api.Trimmer;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.api.ValueType;
import org.yarnandtail.andhow.property.PropertyBase;
import org.yarnandtail.andhow.property.PropertyBuilderBase;
import org.yarnandtail.andhow.property.QuotedSpacePreservingTrimmer;
import org.yarnandtail.andhow.valid.StringValidator;
import org.yarnandtail.andhow.valuetype.StrType;

public class StrProp
extends PropertyBase<String> {
    public StrProp(String defaultValue, boolean nonNull, String shortDesc, List<Validator<String>> validators, List<Name> aliases, PropertyType paramType, ValueType<String> valueType, Trimmer trimmer, String helpText) {
        super(defaultValue, nonNull, shortDesc, validators, aliases, paramType, valueType, trimmer, helpText);
    }

    public static StrBuilder builder() {
        return new StrBuilder();
    }

    public static class StrBuilder
    extends PropertyBuilderBase<StrBuilder, StrProp, String> {
        public StrBuilder() {
            this.instance = this;
            this.valueType(StrType.instance());
            this.trimmer(QuotedSpacePreservingTrimmer.instance());
        }

        @Override
        public StrProp build() {
            return new StrProp((String)this._defaultValue, this._nonNull, this._desc, this._validators, (List<Name>)this._aliases, PropertyType.SINGLE_NAME_VALUE, this._valueType, this._trimmer, this._helpText);
        }

        @Deprecated
        public StrBuilder mustMatchRegex(String regex) {
            return this.matches(regex);
        }

        public StrBuilder matches(String regex) {
            this.validation(new StringValidator.Regex(regex));
            return this;
        }

        @Deprecated
        public StrBuilder mustStartWith(String prefix) {
            return this.startsWith(prefix);
        }

        public StrBuilder startsWith(String prefix) {
            this.validation(new StringValidator.StartsWith(prefix, false));
            return this;
        }

        @Deprecated
        public StrBuilder mustStartWithIgnoreCase(String prefix) {
            return this.startsWithIgnoringCase(prefix);
        }

        public StrBuilder startsWithIgnoringCase(String prefix) {
            this.validation(new StringValidator.StartsWith(prefix, true));
            return this;
        }

        @Deprecated
        public StrBuilder mustEndWith(String sufix) {
            return this.endsWith(sufix);
        }

        public StrBuilder endsWith(String suffix) {
            this.validation(new StringValidator.EndsWith(suffix, false));
            return this;
        }

        @Deprecated
        public StrBuilder mustEndWithIgnoreCase(String sufix) {
            return this.endsWithIgnoringCase(sufix);
        }

        public StrBuilder endsWithIgnoringCase(String suffix) {
            this.validation(new StringValidator.EndsWith(suffix, true));
            return this;
        }

        @Deprecated
        public StrBuilder mustEqual(String ... values) {
            return this.oneOf(values);
        }

        public StrBuilder oneOf(String ... values) {
            this.validation(new StringValidator.OneOf(values));
            return this;
        }

        public StrBuilder oneOfIgnoringCase(String ... values) {
            this.validation(new StringValidator.OneOfIgnoringCase(values));
            return this;
        }
    }
}

