/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.yarnandtail.andhow.AndHowConfiguration;
import org.yarnandtail.andhow.AndHowInit;
import org.yarnandtail.andhow.AndHowTestInit;
import org.yarnandtail.andhow.service.InitLoader;

public class TestInitLoader
extends InitLoader {
    private final ServiceLoader<AndHowTestInit> loader;
    private final Object lock = new Object();

    public TestInitLoader() {
        this(TestInitLoader.class.getClassLoader());
    }

    public TestInitLoader(ClassLoader classLoader) {
        ClassLoader cl = classLoader != null ? classLoader : TestInitLoader.class.getClassLoader();
        this.loader = ServiceLoader.load(AndHowTestInit.class, cl);
    }

    @Override
    public boolean isValidState() {
        return this.getInitInstances().size() <= 1;
    }

    @Override
    public boolean hasConfig() {
        return this.getInitInstances().size() > 0;
    }

    @Override
    public AndHowConfiguration getAndHowConfiguration(AndHowConfiguration defaultConfig) {
        if (this.getInitInstances().size() == 1) {
            return this.getInitInstances().get(0).getConfiguration();
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AndHowInit> getInitInstances() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<AndHowInit> list = new ArrayList<AndHowInit>();
            Iterator<AndHowTestInit> it = this.loader.iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            this.loader.reload();
        }
    }
}

