/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AndHowLogFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_CYAN = "\u001b[36m";
    private static final String mandatoryNoteFormat = "\u001b[36m%1$tF %1$tT | %4$s | %2$s | %5$s%6$s\u001b[0m%n";
    private static final String normalFormat = "%1$tF %1$tT | %4$s | %2$s | %5$s%6$s%n";
    private static final String severeFormat = "\u001b[31m%1$tF %1$tT | %4$s | %2$s | %5$s%6$s\u001b[0m%n";
    private final Date date = new Date();

    @Override
    public String format(LogRecord record) {
        String source;
        this.date.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        if (record.getLevel().intValue() < Level.SEVERE.intValue()) {
            return String.format(normalFormat, this.date, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
        }
        if (message.startsWith("!!Important Note!! ")) {
            return String.format(mandatoryNoteFormat, this.date, source, record.getLoggerName(), Level.INFO, message.substring("!!Important Note!! ".length()), throwable);
        }
        return String.format(severeFormat, this.date, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }
}

