/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    public static final String NULL_PRINT = "[[NULL]]";
    public static final String SECOND_LINE_INDENT = "  ";
    private static final String PAD = "[[00PAD00]]";

    public static void println(PrintStream out, String pattern, Object ... args) {
        out.println(TextUtil.format(pattern, args));
    }

    public static void println(PrintStream out, int maxLineLength, String linePrefix, String pattern, Object ... args) {
        String content = TextUtil.format(pattern, args);
        List<String> chunks = TextUtil.wrap(content, maxLineLength, linePrefix, SECOND_LINE_INDENT);
        for (String s : chunks) {
            out.println(s);
        }
    }

    public static void println(PrintStream out, int maxLineLength, String linePrefix, String content) {
        List<String> chunks = TextUtil.wrap(content, maxLineLength, linePrefix, SECOND_LINE_INDENT);
        for (String s : chunks) {
            out.println(s);
        }
    }

    public static String format(String pattern, Object ... args) {
        String padded = PAD + pattern + PAD;
        String[] tokens = padded.split("(?<!\\\\)(\\{})");
        if (tokens.length > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(tokens[0]);
            for (int i = 1; i < tokens.length; ++i) {
                if (args != null && args[i - 1] != null) {
                    sb.append(args[i - 1]);
                } else {
                    sb.append(NULL_PRINT);
                }
                sb.append(tokens[i]);
            }
            return sb.substring(11, sb.length() - 11);
        }
        return pattern;
    }

    public static String repeat(String base, int repeat) {
        return new String(new char[repeat]).replace("\u0000", base);
    }

    public static String padRight(String base, String repeatString, int totalLength) {
        if (base == null) {
            return null;
        }
        if (base.length() < totalLength) {
            if (repeatString == null) {
                repeatString = " ";
            }
            StringBuilder sb = new StringBuilder(base);
            while (sb.length() < totalLength) {
                sb.append(repeatString);
            }
            return sb.substring(0, totalLength);
        }
        return base;
    }

    public static String trimToNull(String source) {
        if (source == null) {
            return null;
        }
        if ((source = source.trim()).length() > 0) {
            return source;
        }
        return null;
    }

    public static String nullToEmpty(String source) {
        if (source != null) {
            return source;
        }
        return "";
    }

    public static String trimToEmpty(String source) {
        if (source == null) {
            return "";
        }
        return source.trim();
    }

    public static boolean toBoolean(String value) {
        String v = TextUtil.trimToNull(value);
        if (v == null) {
            return false;
        }
        return (v = v.toLowerCase()).equals("true") || v.equals("t") || v.equals("yes") || v.equals("y") || v.equals("on");
    }

    public static List<String> wrap(String in, int length, String prefix, String wrappedLineIndent) {
        if (prefix == null) {
            prefix = "";
        }
        if (wrappedLineIndent == null) {
            wrappedLineIndent = "";
        }
        List<String> result = TextUtil.wrap(in, length - prefix.length());
        for (int i = 0; i < result.size(); ++i) {
            if (i == 0) {
                result.set(i, prefix + result.get(i));
                continue;
            }
            result.set(i, prefix + wrappedLineIndent + result.get(i));
        }
        return result;
    }

    public static List<String> wrap(String in, int length) {
        if ((in = in.trim()).length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(2);
        if (in.length() < length) {
            result.add(in);
            return result;
        }
        if (in.substring(0, length).contains("\n")) {
            result.addAll(TextUtil.wrap(in.substring(0, in.indexOf("\n")).trim(), length));
            result.addAll(TextUtil.wrap(in.substring(in.indexOf("\n") + 1).trim(), length));
            return result;
        }
        int allowedShortLength = (int)(0.8 * (double)length);
        int effectiveBreak = -1;
        int leftBreak = TextUtil.findLastInstanceOf(in, length, " ", "\t", "-");
        int rightBreak = TextUtil.findFirstInstanceOf(in, length, " ", "\t", "-");
        effectiveBreak = leftBreak >= allowedShortLength ? leftBreak : rightBreak;
        if (effectiveBreak > -1) {
            result.add(in.substring(0, effectiveBreak).trim());
            result.addAll(TextUtil.wrap(in.substring(effectiveBreak + 1).trim(), length));
        } else {
            result.add(in);
        }
        return result;
    }

    public static int findFirstInstanceOf(String toBeSearched, int searchFrom, String ... toBeFound) {
        int result = -1;
        if (toBeSearched != null && toBeFound.length > 0) {
            for (String s : toBeFound) {
                int i = toBeSearched.indexOf(s, searchFrom);
                if (i <= -1 || i >= result && result != -1) continue;
                result = i;
            }
        }
        return result;
    }

    public static int findLastInstanceOf(String toBeSearched, int searchFrom, String ... toBeFound) {
        int result = -1;
        if (toBeSearched != null && toBeFound.length > 0) {
            for (String s : toBeFound) {
                int i = toBeSearched.lastIndexOf(s, searchFrom);
                if (i <= result) continue;
                result = i;
            }
        }
        return result;
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder escapedXML = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    escapedXML.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        escapedXML.append("&#" + c + ";");
                        continue block7;
                    }
                    escapedXML.append(c);
                }
            }
        }
        return escapedXML.toString();
    }
}

