/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.common.args;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Args {
    private Args() {
    }

    @Nonnull
    public static <V> V requireNonNull(V value, @Nonnull String message) {
        return (V)Args.requireSatisfies(value, Objects::nonNull, message);
    }

    public static <V> V requireSatisfies(@Nullable V value, @Nonnull Predicate<V> predicate, @Nonnull String message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

