/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.common.args;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.yatech.common.args.Args;

public abstract class CollectionArgs {
    private CollectionArgs() {
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireContains(C collection, E element, @Nonnull String message) {
        return (C)Args.requireSatisfies(collection, c -> c != null && c.contains(element), message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireContainsKey(M map, K key, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> m != null && m.containsKey(key), message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireContainsValue(M map, V value, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> m != null && m.containsValue(value), message);
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireExcludes(C collection, E element, @Nonnull String message) {
        return (C)Args.requireSatisfies(collection, c -> !c.contains(element), message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireExcludesKey(M map, K key, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> !m.containsKey(key), message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireExcludesValue(M map, V value, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> !m.containsValue(value), message);
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireMaxSize(C collection, int size, @Nonnull String message) {
        return (C)Args.requireSatisfies(collection, c -> c != null && c.size() <= size, message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireMaxSize(M map, int size, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> m != null && m.size() <= size, message);
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireEmpty(C collection, @Nonnull String message) {
        return CollectionArgs.requireMaxSize(collection, 0, message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireEmpty(M map, @Nonnull String message) {
        return CollectionArgs.requireMaxSize(map, 0, message);
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireMinSize(C collection, int size, @Nonnull String message) {
        return (C)Args.requireSatisfies(collection, c -> c != null && c.size() >= size, message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireMinSize(M map, int size, @Nonnull String message) {
        return (M)Args.requireSatisfies(map, m -> m != null && m.size() >= size, message);
    }

    @Nonnull
    public static <C extends Collection<E>, E> C requireNonEmpty(C collection, @Nonnull String message) {
        return CollectionArgs.requireMinSize(collection, 1, message);
    }

    @Nonnull
    public static <M extends Map<K, V>, K, V> M requireNonEmpty(M map, @Nonnull String message) {
        return CollectionArgs.requireMinSize(map, 1, message);
    }
}

