/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.common.args;

import javax.annotation.Nonnull;
import org.yatech.common.args.Args;

public abstract class NumericArgs {
    private NumericArgs() {
    }

    public static long requirePositive(Long value, String message) {
        return NumericArgs.requireGreaterThan(value, 0L, message);
    }

    public static long requireNonNegative(Long value, String message) {
        return NumericArgs.requireGreaterThanEquals(value, 0L, message);
    }

    public static long requireGreaterThan(Long value, long other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v > other, message);
    }

    public static long requireGreaterThanEquals(Long value, long other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v >= other, message);
    }

    public static long requireNegative(Long value, String message) {
        return NumericArgs.requireLessThan(value, 0L, message);
    }

    public static long requireNonPositive(Long value, String message) {
        return NumericArgs.requireLessThanEquals(value, 0L, message);
    }

    public static long requireLessThan(Long value, long other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v < other, message);
    }

    public static long requireLessThanEquals(Long value, long other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v <= other, message);
    }

    public static long requireNonZero(Long value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v != 0L, message);
    }

    public static long requireInRangeInclusive(Long value, long from, long to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, true, to, true, message);
    }

    public static long requireInRangeExclusive(Long value, long from, long to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, false, to, false, message);
    }

    public static long requireInRange(Long value, long from, boolean fromInclusive, long to, boolean toInclusive, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && (fromInclusive ? v >= from : v > from) && (toInclusive ? value <= to : value < to), message);
    }

    public static int requirePositive(Integer value, String message) {
        return NumericArgs.requireGreaterThan(value, 0, message);
    }

    public static int requireNonNegative(Integer value, String message) {
        return NumericArgs.requireGreaterThanEquals(value, 0, message);
    }

    public static int requireGreaterThan(Integer value, int other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v > other, message);
    }

    public static int requireGreaterThanEquals(Integer value, int other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v >= other, message);
    }

    public static int requireNegative(Integer value, String message) {
        return NumericArgs.requireLessThan(value, 0, message);
    }

    public static int requireNonPositive(Integer value, String message) {
        return NumericArgs.requireLessThanEquals(value, 0, message);
    }

    public static int requireLessThan(Integer value, int other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v < other, message);
    }

    public static int requireLessThanEquals(Integer value, int other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v <= other, message);
    }

    public static int requireNonZero(Integer value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v != 0, message);
    }

    public static int requireInRangeInclusive(Integer value, int from, int to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, true, to, true, message);
    }

    public static int requireInRangeExclusive(Integer value, int from, int to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, false, to, false, message);
    }

    public static int requireInRange(Integer value, int from, boolean fromInclusive, int to, boolean toInclusive, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && (fromInclusive ? v >= from : v > from) && (toInclusive ? value <= to : value < to), message);
    }

    public static double requirePositive(Double value, String message) {
        return NumericArgs.requireGreaterThan(value, 0.0, message);
    }

    public static double requireNonNegative(Double value, String message) {
        return NumericArgs.requireGreaterThanEquals(value, 0.0, message);
    }

    public static double requireGreaterThan(Double value, double other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v > other, message);
    }

    public static double requireGreaterThanEquals(Double value, double other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v >= other, message);
    }

    public static double requireNegative(Double value, String message) {
        return NumericArgs.requireLessThan(value, 0.0, message);
    }

    public static double requireNonPositive(Double value, String message) {
        return NumericArgs.requireLessThanEquals(value, 0.0, message);
    }

    public static double requireLessThan(Double value, double other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v < other, message);
    }

    public static double requireLessThanEquals(Double value, double other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v <= other, message);
    }

    public static double requireNonZero(Double value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v != 0.0, message);
    }

    public static double requireInRangeInclusive(Double value, double from, double to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, true, to, true, message);
    }

    public static double requireInRangeExclusive(Double value, double from, double to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, false, to, false, message);
    }

    public static double requireInRange(Double value, double from, boolean fromInclusive, double to, boolean toInclusive, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && (fromInclusive ? v >= from : v > from) && (toInclusive ? value <= to : value < to), message);
    }

    public static float requirePositive(Float value, String message) {
        return NumericArgs.requireGreaterThan(value, 0.0f, message);
    }

    public static float requireNonNegative(Float value, String message) {
        return NumericArgs.requireGreaterThanEquals(value, 0.0f, message);
    }

    public static float requireGreaterThan(Float value, float other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.floatValue() > other, message).floatValue();
    }

    public static float requireGreaterThanEquals(Float value, float other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.floatValue() >= other, message).floatValue();
    }

    public static float requireNegative(Float value, String message) {
        return NumericArgs.requireLessThan(value, 0.0f, message);
    }

    public static float requireNonPositive(Float value, String message) {
        return NumericArgs.requireLessThanEquals(value, 0.0f, message);
    }

    public static float requireLessThan(Float value, float other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.floatValue() < other, message).floatValue();
    }

    public static float requireLessThanEquals(Float value, float other, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.floatValue() <= other, message).floatValue();
    }

    public static float requireNonZero(Float value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.floatValue() != 0.0f, message).floatValue();
    }

    public static float requireInRangeInclusive(Float value, float from, float to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, true, to, true, message);
    }

    public static float requireInRangeExclusive(Float value, float from, float to, @Nonnull String message) {
        return NumericArgs.requireInRange(value, from, false, to, false, message);
    }

    public static float requireInRange(Float value, float from, boolean fromInclusive, float to, boolean toInclusive, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && (fromInclusive ? v.floatValue() >= from : v.floatValue() > from) && (toInclusive ? value.floatValue() <= to : value.floatValue() < to), message).floatValue();
    }
}

