/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.common.args;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.yatech.common.args.Args;

public abstract class StringArgs {
    public static final Pattern WHITESPACES_ONLY = Pattern.compile("\\s+");

    private StringArgs() {
    }

    @Nonnull
    public static String requireNonBlank(String value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.length() > 0 && !WHITESPACES_ONLY.matcher((CharSequence)v).matches(), message);
    }

    @Nonnull
    public static String requireNonEmpty(String value, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && v.length() > 0, message);
    }

    @Nonnull
    public static String requireMatches(String value, @Nonnull Pattern pattern, @Nonnull String message) {
        return Args.requireSatisfies(value, v -> v != null && pattern.matcher((CharSequence)v).matches(), message);
    }
}

