/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.StringUtils;

public class ServerEndpointConfig {
    private final String HOST;
    private final int PORT;
    private final Set<String> PATH_SET;
    private final int CONNECT_TIMEOUT_MILLIS;
    private final int SO_BACKLOG;
    private final int WRITE_SPIN_COUNT;
    private final int WRITE_BUFFER_HIGH_WATER_MARK;
    private final int WRITE_BUFFER_LOW_WATER_MARK;
    private final int SO_RCVBUF;
    private final int SO_SNDBUF;
    private final boolean TCP_NODELAY;
    private final boolean SO_KEEPALIVE;
    private final int SO_LINGER;
    private final boolean ALLOW_HALF_CLOSURE;
    private final int READER_IDLE_TIME_SECONDS;
    private final int WRITER_IDLE_TIME_SECONDS;
    private final int ALL_IDLE_TIME_SECONDS;
    private static Integer randomPort;

    public ServerEndpointConfig(String host, int port, String path, int connectTimeoutMillis, int soBacklog, int writeSpinCount, int writeBufferHighWaterMark, int writeBufferLowWaterMark, int soRcvbuf, int soSndbuf, boolean tcpNodelay, boolean soKeepalive, int soLinger, boolean allowHalfClosure, int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this.HOST = StringUtils.isEmpty((Object)host) || "0.0.0.0".equals(host) || "0.0.0.0/0.0.0.0".equals(host) ? "0.0.0.0" : host;
        this.PORT = this.getAvailablePort(port);
        this.PATH_SET = new HashSet<String>();
        this.addPath(path);
        this.CONNECT_TIMEOUT_MILLIS = connectTimeoutMillis;
        this.SO_BACKLOG = soBacklog;
        this.WRITE_SPIN_COUNT = writeSpinCount;
        this.WRITE_BUFFER_HIGH_WATER_MARK = writeBufferHighWaterMark;
        this.WRITE_BUFFER_LOW_WATER_MARK = writeBufferLowWaterMark;
        this.SO_RCVBUF = soRcvbuf;
        this.SO_SNDBUF = soSndbuf;
        this.TCP_NODELAY = tcpNodelay;
        this.SO_KEEPALIVE = soKeepalive;
        this.SO_LINGER = soLinger;
        this.ALLOW_HALF_CLOSURE = allowHalfClosure;
        this.READER_IDLE_TIME_SECONDS = readerIdleTimeSeconds;
        this.WRITER_IDLE_TIME_SECONDS = writerIdleTimeSeconds;
        this.ALL_IDLE_TIME_SECONDS = allIdleTimeSeconds;
    }

    public String addPath(String path) {
        if (StringUtils.isEmpty((Object)path)) {
            path = "/";
        }
        if (this.PATH_SET.contains(path)) {
            throw new RuntimeException("ServerEndpointConfig.addPath  path:" + path + " are repeat.");
        }
        this.PATH_SET.add(path);
        return path;
    }

    private int getAvailablePort(int port) {
        if (port != 0) {
            return port;
        }
        if (randomPort != null && randomPort != 0) {
            return randomPort;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(0);
        Socket socket = new Socket();
        try {
            socket.bind(inetSocketAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int localPort = socket.getLocalPort();
        try {
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        randomPort = localPort;
        return localPort;
    }

    public String getHost() {
        return this.HOST;
    }

    public int getPort() {
        return this.PORT;
    }

    public Set<String> getPathSet() {
        return this.PATH_SET;
    }

    public int getConnectTimeoutMillis() {
        return this.CONNECT_TIMEOUT_MILLIS;
    }

    public int getSoBacklog() {
        return this.SO_BACKLOG;
    }

    public int getWriteSpinCount() {
        return this.WRITE_SPIN_COUNT;
    }

    public int getWriteBufferHighWaterMark() {
        return this.WRITE_BUFFER_HIGH_WATER_MARK;
    }

    public int getWriteBufferLowWaterMark() {
        return this.WRITE_BUFFER_LOW_WATER_MARK;
    }

    public int getSoRcvbuf() {
        return this.SO_RCVBUF;
    }

    public int getSoSndbuf() {
        return this.SO_SNDBUF;
    }

    public boolean isTcpNodelay() {
        return this.TCP_NODELAY;
    }

    public boolean isSoKeepalive() {
        return this.SO_KEEPALIVE;
    }

    public int getSoLinger() {
        return this.SO_LINGER;
    }

    public boolean isAllowHalfClosure() {
        return this.ALLOW_HALF_CLOSURE;
    }

    public static Integer getRandomPort() {
        return randomPort;
    }

    public int getReaderIdleTimeSeconds() {
        return this.READER_IDLE_TIME_SECONDS;
    }

    public int getWriterIdleTimeSeconds() {
        return this.WRITER_IDLE_TIME_SECONDS;
    }

    public int getAllIdleTimeSeconds() {
        return this.ALL_IDLE_TIME_SECONDS;
    }
}

