/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.pojo;

import io.netty.handler.codec.http.HttpHeaders;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.yeauty.annotation.OnBinary;
import org.yeauty.annotation.OnClose;
import org.yeauty.annotation.OnError;
import org.yeauty.annotation.OnEvent;
import org.yeauty.annotation.OnMessage;
import org.yeauty.annotation.OnOpen;
import org.yeauty.exception.DeploymentException;
import org.yeauty.pojo.PojoPathParam;
import org.yeauty.pojo.Session;

public class PojoMethodMapping {
    private final Method onOpen;
    private final Method onClose;
    private final Method onError;
    private final Method onMessage;
    private final Method onBinary;
    private final Method onEvent;
    private final PojoPathParam[] onOpenParams;
    private final PojoPathParam[] onCloseParams;
    private final PojoPathParam[] onErrorParams;
    private final PojoPathParam[] onMessageParams;
    private final PojoPathParam[] onBinaryParams;
    private final PojoPathParam[] onEventParams;
    private final Class pojoClazz;
    private final ApplicationContext applicationContext;

    public PojoMethodMapping(Class<?> pojoClazz, ApplicationContext context) throws DeploymentException {
        this.applicationContext = context;
        this.pojoClazz = pojoClazz;
        Method open = null;
        Method close = null;
        Method error = null;
        Method message = null;
        Method binary = null;
        Method event = null;
        Method[] pojoClazzMethods = null;
        Class<?> currentClazz = pojoClazz;
        while (!currentClazz.equals(Object.class)) {
            Method[] currentClazzMethods = currentClazz.getDeclaredMethods();
            if (currentClazz == pojoClazz) {
                pojoClazzMethods = currentClazzMethods;
            }
            for (Method method : currentClazzMethods) {
                if (method.getAnnotation(OnOpen.class) != null) {
                    this.checkPublic(method);
                    if (open == null) {
                        open = method;
                        continue;
                    }
                    if (currentClazz != pojoClazz && this.isMethodOverride(open, method)) continue;
                    throw new DeploymentException("pojoMethodMapping.duplicateAnnotation OnOpen");
                }
                if (method.getAnnotation(OnClose.class) != null) {
                    this.checkPublic(method);
                    if (close == null) {
                        close = method;
                        continue;
                    }
                    if (currentClazz != pojoClazz && this.isMethodOverride(close, method)) continue;
                    throw new DeploymentException("pojoMethodMapping.duplicateAnnotation OnClose");
                }
                if (method.getAnnotation(OnError.class) != null) {
                    this.checkPublic(method);
                    if (error == null) {
                        error = method;
                        continue;
                    }
                    if (currentClazz != pojoClazz && this.isMethodOverride(error, method)) continue;
                    throw new DeploymentException("pojoMethodMapping.duplicateAnnotation OnError");
                }
                if (method.getAnnotation(OnMessage.class) != null) {
                    this.checkPublic(method);
                    if (message == null) {
                        message = method;
                        continue;
                    }
                    if (currentClazz != pojoClazz && this.isMethodOverride(message, method)) continue;
                    throw new DeploymentException("pojoMethodMapping.duplicateAnnotation onMessage");
                }
                if (method.getAnnotation(OnBinary.class) != null) {
                    this.checkPublic(method);
                    if (binary == null) {
                        binary = method;
                        continue;
                    }
                    if (currentClazz != pojoClazz && this.isMethodOverride(binary, method)) continue;
                    throw new DeploymentException("pojoMethodMapping.duplicateAnnotation OnBinary");
                }
                if (method.getAnnotation(OnEvent.class) == null) continue;
                this.checkPublic(method);
                if (event == null) {
                    event = method;
                    continue;
                }
                if (currentClazz != pojoClazz && this.isMethodOverride(event, method)) continue;
                throw new DeploymentException("pojoMethodMapping.duplicateAnnotation OnEvent");
            }
            currentClazz = currentClazz.getSuperclass();
        }
        if (open != null && open.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, open, OnOpen.class)) {
            open = null;
        }
        if (close != null && close.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, close, OnClose.class)) {
            close = null;
        }
        if (error != null && error.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, error, OnError.class)) {
            error = null;
        }
        if (message != null && message.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, message, OnMessage.class)) {
            message = null;
        }
        if (binary != null && binary.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, binary, OnBinary.class)) {
            binary = null;
        }
        if (event != null && event.getDeclaringClass() != pojoClazz && this.isOverridenWithoutAnnotation(pojoClazzMethods, event, OnEvent.class)) {
            event = null;
        }
        this.onOpen = open;
        this.onClose = close;
        this.onError = error;
        this.onMessage = message;
        this.onBinary = binary;
        this.onEvent = event;
        this.onOpenParams = PojoMethodMapping.getPathParams(this.onOpen, MethodType.ON_OPEN);
        this.onCloseParams = PojoMethodMapping.getPathParams(this.onClose, MethodType.ON_CLOSE);
        this.onErrorParams = PojoMethodMapping.getPathParams(this.onError, MethodType.ON_ERROR);
        this.onMessageParams = PojoMethodMapping.getPathParams(this.onMessage, MethodType.ON_MESSAGE);
        this.onBinaryParams = PojoMethodMapping.getPathParams(this.onBinary, MethodType.ON_BINARY);
        this.onEventParams = PojoMethodMapping.getPathParams(this.onEvent, MethodType.ON_EVENT);
    }

    private void checkPublic(Method m) throws DeploymentException {
        if (!Modifier.isPublic(m.getModifiers())) {
            throw new DeploymentException("pojoMethodMapping.methodNotPublic " + m.getName());
        }
    }

    private boolean isMethodOverride(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    private boolean isOverridenWithoutAnnotation(Method[] methods, Method superclazzMethod, Class<? extends Annotation> annotation) {
        for (Method method : methods) {
            if (!this.isMethodOverride(method, superclazzMethod) || method.getAnnotation(annotation) != null) continue;
            return true;
        }
        return false;
    }

    public Object getEndpointInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object implement = this.pojoClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        AutowiredAnnotationBeanPostProcessor postProcessor = (AutowiredAnnotationBeanPostProcessor)this.applicationContext.getBean(AutowiredAnnotationBeanPostProcessor.class);
        postProcessor.postProcessPropertyValues(null, null, implement, null);
        return implement;
    }

    public Method getOnOpen() {
        return this.onOpen;
    }

    public Object[] getOnOpenArgs(Session session, HttpHeaders headers) {
        return PojoMethodMapping.buildArgs(this.onOpenParams, session, headers, null, null, null, null);
    }

    public Method getOnClose() {
        return this.onClose;
    }

    public Object[] getOnCloseArgs(Session session) {
        return PojoMethodMapping.buildArgs(this.onCloseParams, session, null, null, null, null, null);
    }

    public Method getOnError() {
        return this.onError;
    }

    public Object[] getOnErrorArgs(Session session, Throwable throwable) {
        return PojoMethodMapping.buildArgs(this.onErrorParams, session, null, null, null, throwable, null);
    }

    public Method getOnMessage() {
        return this.onMessage;
    }

    public Object[] getOnMessageArgs(Session session, String text) {
        return PojoMethodMapping.buildArgs(this.onMessageParams, session, null, text, null, null, null);
    }

    public Method getOnBinary() {
        return this.onBinary;
    }

    public Object[] getOnBinaryArgs(Session session, byte[] bytes) {
        return PojoMethodMapping.buildArgs(this.onBinaryParams, session, null, null, bytes, null, null);
    }

    public Method getOnEvent() {
        return this.onEvent;
    }

    public Object[] getOnEventArgs(Session session, Object evt) {
        return PojoMethodMapping.buildArgs(this.onEventParams, session, null, null, null, null, evt);
    }

    private static PojoPathParam[] getPathParams(Method m, MethodType methodType) throws DeploymentException {
        if (m == null) {
            return new PojoPathParam[0];
        }
        boolean foundThrowable = false;
        Class<?>[] types = m.getParameterTypes();
        PojoPathParam[] result = new PojoPathParam[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (type.equals(Session.class)) {
                result[i] = new PojoPathParam(type, "session");
                continue;
            }
            if (methodType == MethodType.ON_OPEN && type.equals(HttpHeaders.class)) {
                result[i] = new PojoPathParam(type, "headers");
                continue;
            }
            if (methodType == MethodType.ON_ERROR && type.equals(Throwable.class)) {
                foundThrowable = true;
                result[i] = new PojoPathParam(type, "throwable");
                continue;
            }
            if (methodType == MethodType.ON_MESSAGE && type.equals(String.class)) {
                result[i] = new PojoPathParam(type, "text");
                continue;
            }
            if (methodType == MethodType.ON_BINARY && type.equals(byte[].class)) {
                result[i] = new PojoPathParam(type, "binary");
                continue;
            }
            if (methodType == MethodType.ON_EVENT && type.equals(Object.class)) {
                result[i] = new PojoPathParam(type, "event");
                continue;
            }
            if (type.equals(org.springframework.boot.web.servlet.server.Session.class)) {
                throw new DeploymentException("expect to import import org.yeauty.pojo.Session not org.springframework.boot.web.servlet.server.Session");
            }
            throw new DeploymentException("pojoMethodMapping.paramClassIncorrect");
        }
        if (methodType == MethodType.ON_ERROR && !foundThrowable) {
            throw new DeploymentException("pojoMethodMapping.onErrorNoThrowable");
        }
        return result;
    }

    private static Object[] buildArgs(PojoPathParam[] pathParams, Session session, HttpHeaders headers, String text, byte[] bytes, Throwable throwable, Object evt) {
        Object[] result = new Object[pathParams.length];
        for (int i = 0; i < pathParams.length; ++i) {
            Class<?> type = pathParams[i].getType();
            if (type.equals(Session.class)) {
                result[i] = session;
                continue;
            }
            if (type.equals(HttpHeaders.class)) {
                result[i] = headers;
                continue;
            }
            if (type.equals(String.class)) {
                result[i] = text;
                continue;
            }
            if (type.equals(byte[].class)) {
                result[i] = bytes;
                continue;
            }
            if (type.equals(Throwable.class)) {
                result[i] = throwable;
                continue;
            }
            if (!type.equals(Object.class)) continue;
            result[i] = evt;
        }
        return result;
    }

    private static enum MethodType {
        ON_OPEN,
        ON_CLOSE,
        ON_MESSAGE,
        ON_BINARY,
        ON_EVENT,
        ON_ERROR;

    }
}

