/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.pojo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParameterMap {
    private Map<String, List<String>> paramHashValues = new LinkedHashMap<String, List<String>>();

    public ParameterMap(String originalParam) {
        String[] params;
        for (String param : params = originalParam.split("&")) {
            String[] keyValue = param.split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            List<String> values = this.paramHashValues.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.paramHashValues.put(key, values);
            }
            values.add(value);
        }
    }

    public Map<String, List<String>> getParameterMap() {
        return this.paramHashValues;
    }

    public List<String> getParameterValues(String name) {
        return this.paramHashValues.get(name);
    }

    public String getParameter(String name) {
        List<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.size() == 0) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public Set<String> getParameterNames() {
        return this.paramHashValues.keySet();
    }
}

