/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Set;
import org.springframework.util.StringUtils;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.standard.ServerEndpointConfig;
import org.yeauty.standard.WebSocketServerHandler;

class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final PojoEndpointServer pojoEndpointServer;
    private final ServerEndpointConfig config;
    private static ByteBuf faviconByteBuf = null;
    private static ByteBuf notFoundByteBuf = null;
    private static ByteBuf badRequestByteBuf = null;
    private static ByteBuf forbiddenByteBuf = null;
    private static ByteBuf internalServerErrorByteBuf = null;

    private static ByteBuf buildStaticRes(String resPath) {
        try {
            int available;
            InputStream inputStream = HttpServerHandler.class.getResourceAsStream(resPath);
            if (inputStream != null && (available = inputStream.available()) != 0) {
                byte[] bytes = new byte[available];
                inputStream.read(bytes);
                return ByteBufAllocator.DEFAULT.buffer(bytes.length).writeBytes(bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public HttpServerHandler(PojoEndpointServer pojoEndpointServer, ServerEndpointConfig config) {
        this.pojoEndpointServer = pojoEndpointServer;
        this.config = config;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        try {
            this.handleHttpRequest(ctx, msg);
        }
        catch (Exception e) {
            DefaultFullHttpResponse res = internalServerErrorByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, internalServerErrorByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            HttpServerHandler.sendHttpResponse(ctx, msg, (FullHttpResponse)res);
            e.printStackTrace();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.pojoEndpointServer.doOnError(ctx, cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.pojoEndpointServer.doOnClose(ctx);
        super.channelInactive(ctx);
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.decoderResult().isSuccess()) {
            DefaultFullHttpResponse res = badRequestByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, badRequestByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (req.method() != HttpMethod.GET) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        HttpHeaders headers = req.headers();
        String host = headers.get((CharSequence)HttpHeaderNames.HOST);
        if (StringUtils.isEmpty((Object)host)) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(StringUtils.isEmpty((Object)this.pojoEndpointServer.getHost()) || this.pojoEndpointServer.getHost().equals("0.0.0.0") || this.pojoEndpointServer.getHost().equals(host.split(":")[0]))) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        String uri = req.uri();
        int index = uri.indexOf("?");
        String path = null;
        Object parameterMap = null;
        String originalParam = null;
        if (index == -1) {
            path = uri;
        } else {
            path = uri.substring(0, index);
            originalParam = uri.substring(index + 1, uri.length());
        }
        if ("/favicon.ico".equals(path)) {
            DefaultFullHttpResponse res = faviconByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, faviconByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        Set<String> pathSet = this.pojoEndpointServer.getPathSet();
        if (pathSet != null && pathSet.size() > 0 && !pathSet.contains(path)) {
            DefaultFullHttpResponse res = notFoundByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, notFoundByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION))) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        Channel channel = ctx.channel();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(HttpServerHandler.getWebSocketLocation(req), null, true, this.config.getmaxFramePayloadLength());
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove(ctx.name());
            if (this.config.getReaderIdleTimeSeconds() != 0 || this.config.getWriterIdleTimeSeconds() != 0 || this.config.getAllIdleTimeSeconds() != 0) {
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.config.getReaderIdleTimeSeconds(), this.config.getWriterIdleTimeSeconds(), this.config.getAllIdleTimeSeconds())});
            }
            if (this.config.isUseCompressionHandler()) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
            }
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.pojoEndpointServer)});
            String finalPath = path;
            String finalOriginalParam = originalParam;
            handshaker.handshake(channel, req).addListener(future -> {
                if (future.isSuccess()) {
                    this.pojoEndpointServer.doOnOpen(ctx, req, finalPath, finalOriginalParam);
                } else {
                    handshaker.close(channel, new CloseWebSocketFrame());
                }
            });
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        int statusCode = res.status().code();
        if (statusCode != HttpResponseStatus.OK.code() && res.content().readableBytes() == 0) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || statusCode != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
        return "ws://" + location;
    }

    static {
        faviconByteBuf = HttpServerHandler.buildStaticRes("/favicon.ico");
        notFoundByteBuf = HttpServerHandler.buildStaticRes("/public/error/404.html");
        badRequestByteBuf = HttpServerHandler.buildStaticRes("/public/error/400.html");
        forbiddenByteBuf = HttpServerHandler.buildStaticRes("/public/error/403.html");
        internalServerErrorByteBuf = HttpServerHandler.buildStaticRes("/public/error/500.html");
        if (notFoundByteBuf == null) {
            notFoundByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (badRequestByteBuf == null) {
            badRequestByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (forbiddenByteBuf == null) {
            forbiddenByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (internalServerErrorByteBuf == null) {
            internalServerErrorByteBuf = HttpServerHandler.buildStaticRes("/public/error/5xx.html");
        }
    }
}

