/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.standard.HttpServerHandler;
import org.yeauty.standard.ServerEndpointConfig;

public class WebsocketServer {
    private final PojoEndpointServer pojoEndpointServer;
    private final ServerEndpointConfig config;

    public WebsocketServer(PojoEndpointServer webSocketServerHandler, ServerEndpointConfig serverEndpointConfig) {
        this.pojoEndpointServer = webSocketServerHandler;
        this.config = serverEndpointConfig;
    }

    public void init() throws InterruptedException {
        ChannelFuture channelFuture;
        NioEventLoopGroup boss = new NioEventLoopGroup(this.config.getBossLoopGroupThreads());
        NioEventLoopGroup worker = new NioEventLoopGroup(this.config.getWorkerLoopGroupThreads());
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker).channel(NioServerSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.getConnectTimeoutMillis())).option(ChannelOption.SO_BACKLOG, (Object)this.config.getSoBacklog())).childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)this.config.getWriteSpinCount()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.config.getWriteBufferLowWaterMark(), this.config.getWriteBufferHighWaterMark())).childOption(ChannelOption.TCP_NODELAY, (Object)this.config.isTcpNodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.config.isSoKeepalive()).childOption(ChannelOption.SO_LINGER, (Object)this.config.getSoLinger()).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)this.config.isAllowHalfClosure()).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                pipeline.addLast(new ChannelHandler[]{new HttpServerHandler(WebsocketServer.this.pojoEndpointServer, WebsocketServer.this.config)});
            }
        });
        if (this.config.getSoRcvbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.config.getSoRcvbuf());
        }
        if (this.config.getSoSndbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.config.getSoSndbuf());
        }
        if ("0.0.0.0".equals(this.config.getHost())) {
            channelFuture = bootstrap.bind(this.config.getPort());
        } else {
            try {
                channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.config.getHost()), this.config.getPort()));
            }
            catch (UnknownHostException e) {
                channelFuture = bootstrap.bind(this.config.getHost(), this.config.getPort());
                e.printStackTrace();
            }
        }
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> WebsocketServer.lambda$init$1((EventLoopGroup)boss, (EventLoopGroup)worker)));
    }

    public PojoEndpointServer getPojoEndpointServer() {
        return this.pojoEndpointServer;
    }

    private static /* synthetic */ void lambda$init$1(EventLoopGroup boss, EventLoopGroup worker) {
        boss.shutdownGracefully().syncUninterruptibly();
        worker.shutdownGracefully().syncUninterruptibly();
    }
}

