/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.yeauty.annotation.ServerEndpoint;
import org.yeauty.exception.DeploymentException;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.pojo.PojoMethodMapping;
import org.yeauty.standard.ServerEndpointConfig;
import org.yeauty.standard.WebsocketServer;

public class ServerEndpointExporter
extends ApplicationObjectSupport
implements SmartInitializingSingleton {
    @Autowired
    Environment environment;
    private final Map<InetSocketAddress, WebsocketServer> addressWebsocketServerMap = new HashMap<InetSocketAddress, WebsocketServer>();

    public void afterSingletonsInstantiated() {
        this.registerEndpoints();
    }

    protected void registerEndpoints() {
        LinkedHashSet<Class> endpointClasses = new LinkedHashSet<Class>();
        ApplicationContext context = this.getApplicationContext();
        if (context != null) {
            String[] endpointBeanNames;
            for (String beanName : endpointBeanNames = context.getBeanNamesForAnnotation(ServerEndpoint.class)) {
                endpointClasses.add(context.getType(beanName));
            }
        }
        for (Class endpointClass : endpointClasses) {
            this.registerEndpoint(endpointClass);
        }
        this.init();
    }

    private void init() {
        for (Map.Entry<InetSocketAddress, WebsocketServer> entry : this.addressWebsocketServerMap.entrySet()) {
            WebsocketServer websocketServer = entry.getValue();
            try {
                websocketServer.init();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("websocket [" + entry.getKey() + "] init fail"), (Throwable)e);
            }
        }
    }

    private void registerEndpoint(Class<?> endpointClass) {
        ServerEndpoint annotation = (ServerEndpoint)AnnotatedElementUtils.findMergedAnnotation(endpointClass, ServerEndpoint.class);
        if (annotation == null) {
            throw new IllegalStateException("missingAnnotation ServerEndpoint");
        }
        String path = annotation.value();
        ServerEndpointConfig serverEndpointConfig = this.buildConfig(annotation);
        ApplicationContext context = this.getApplicationContext();
        PojoMethodMapping pojoMethodMapping = null;
        try {
            pojoMethodMapping = new PojoMethodMapping(endpointClass, context);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException("Failed to register ServerEndpointConfig: " + serverEndpointConfig, e);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverEndpointConfig.getHost(), serverEndpointConfig.getPort());
        WebsocketServer websocketServer = this.addressWebsocketServerMap.get(inetSocketAddress);
        if (websocketServer == null) {
            PojoEndpointServer pojoEndpointServer = new PojoEndpointServer(pojoMethodMapping, serverEndpointConfig);
            websocketServer = new WebsocketServer(pojoEndpointServer, serverEndpointConfig);
            this.addressWebsocketServerMap.put(inetSocketAddress, websocketServer);
        } else {
            websocketServer.getPojoEndpointServer().addPathPojoMethodMapping(path, pojoMethodMapping);
        }
    }

    private ServerEndpointConfig buildConfig(ServerEndpoint annotation) {
        String host = annotation.host();
        int port = annotation.port();
        String path = annotation.value();
        int bossLoopGroupThreads = annotation.bossLoopGroupThreads();
        int workerLoopGroupThreads = annotation.workerLoopGroupThreads();
        boolean useCompressionHandler = annotation.useCompressionHandler();
        int optionConnectTimeoutMillis = annotation.optionConnectTimeoutMillis();
        int optionSoBacklog = annotation.optionSoBacklog();
        int childOptionWriteSpinCount = annotation.childOptionWriteSpinCount();
        int childOptionWriteBufferHighWaterMark = annotation.childOptionWriteBufferHighWaterMark();
        int childOptionWriteBufferLowWaterMark = annotation.childOptionWriteBufferLowWaterMark();
        int childOptionSoRcvbuf = annotation.childOptionSoRcvbuf();
        int childOptionSoSndbuf = annotation.childOptionSoSndbuf();
        boolean childOptionTcpNodelay = annotation.childOptionTcpNodelay();
        boolean childOptionSoKeepalive = annotation.childOptionSoKeepalive();
        int childOptionSoLinger = annotation.childOptionSoLinger();
        boolean childOptionAllowHalfClosure = annotation.childOptionAllowHalfClosure();
        int readerIdleTimeSeconds = annotation.readerIdleTimeSeconds();
        int writerIdleTimeSeconds = annotation.writerIdleTimeSeconds();
        int allIdleTimeSeconds = annotation.allIdleTimeSeconds();
        int maxFramePayloadLength = annotation.maxFramePayloadLength();
        String prefix = annotation.prefix();
        if (!StringUtils.isEmpty((Object)prefix)) {
            Integer maxFramePayloadLengthEnv;
            Integer allIdleTimeSecondsFromEnv;
            Integer writerIdleTimeSecondsFromEnv;
            Integer readerIdleTimeSecondsFromEnv;
            Boolean childOptionAllowHalfClosureFromEnv;
            Integer childOptionSoLingerFromEnv;
            Boolean childOptionSoKeepaliveFromEnv;
            Boolean childOptionTcpNodelayFromEnv;
            Integer childOptionSoSndbufFromEnv;
            Integer childOptionSoRcvbufFromEnv;
            Integer childOptionWriteBufferLowWaterMarkFromEnv;
            Integer childOptionWriteBufferHighWaterMarkFromEnv;
            Integer childOptionWriteSpinCountFromEnv;
            Integer optionSoBacklogFromEnv;
            Integer optionConnectTimeoutMillisFromEnv;
            Boolean useCompressionHandlerFromEnv;
            Integer workerLoopGroupThreadsFromEnv;
            Integer bossLoopGroupThreadsFromEnv;
            String pathFromEnv;
            Integer portFromEnv;
            String hostFromEnv = (String)this.environment.getProperty(prefix + ".host", String.class);
            if (hostFromEnv != null) {
                host = hostFromEnv;
            }
            if ((portFromEnv = (Integer)this.environment.getProperty(prefix + ".port", Integer.class)) != null) {
                port = portFromEnv;
            }
            if ((pathFromEnv = (String)this.environment.getProperty(prefix + ".path", String.class)) != null) {
                path = pathFromEnv;
            }
            if ((bossLoopGroupThreadsFromEnv = (Integer)this.environment.getProperty(prefix + ".boss-loop-group-threads", Integer.class)) != null) {
                bossLoopGroupThreads = bossLoopGroupThreadsFromEnv;
            }
            if ((workerLoopGroupThreadsFromEnv = (Integer)this.environment.getProperty(prefix + ".worker-loop-group-threads", Integer.class)) != null) {
                workerLoopGroupThreads = workerLoopGroupThreadsFromEnv;
            }
            if ((useCompressionHandlerFromEnv = (Boolean)this.environment.getProperty(prefix + ".use-compression-handler", Boolean.class)) != null) {
                useCompressionHandler = useCompressionHandlerFromEnv;
            }
            if ((optionConnectTimeoutMillisFromEnv = (Integer)this.environment.getProperty(prefix + ".option.connect-timeout-millis", Integer.class)) != null) {
                optionConnectTimeoutMillis = optionConnectTimeoutMillisFromEnv;
            }
            if ((optionSoBacklogFromEnv = (Integer)this.environment.getProperty(prefix + ".option.so-backlog", Integer.class)) != null) {
                optionSoBacklog = optionSoBacklogFromEnv;
            }
            if ((childOptionWriteSpinCountFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.write-spin-count", Integer.class)) != null) {
                childOptionWriteSpinCount = childOptionWriteSpinCountFromEnv;
            }
            if ((childOptionWriteBufferHighWaterMarkFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.write-buffer-high-water-mark", Integer.class)) != null) {
                childOptionWriteBufferHighWaterMark = childOptionWriteBufferHighWaterMarkFromEnv;
            }
            if ((childOptionWriteBufferLowWaterMarkFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.write-buffer-low-water-mark", Integer.class)) != null) {
                childOptionWriteBufferLowWaterMark = childOptionWriteBufferLowWaterMarkFromEnv;
            }
            if ((childOptionSoRcvbufFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.so-rcvbuf", Integer.class)) != null) {
                childOptionSoRcvbuf = childOptionSoRcvbufFromEnv;
            }
            if ((childOptionSoSndbufFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.so-sndbuf", Integer.class)) != null) {
                childOptionSoSndbuf = childOptionSoSndbufFromEnv;
            }
            if ((childOptionTcpNodelayFromEnv = (Boolean)this.environment.getProperty(prefix + ".child-option.tcp-nodelay", Boolean.class)) != null) {
                childOptionTcpNodelay = childOptionTcpNodelayFromEnv;
            }
            if ((childOptionSoKeepaliveFromEnv = (Boolean)this.environment.getProperty(prefix + ".child-option.so-keepalive", Boolean.class)) != null) {
                childOptionSoKeepalive = childOptionSoKeepaliveFromEnv;
            }
            if ((childOptionSoLingerFromEnv = (Integer)this.environment.getProperty(prefix + ".child-option.so-linger", Integer.class)) != null) {
                childOptionSoLinger = childOptionSoLingerFromEnv;
            }
            if ((childOptionAllowHalfClosureFromEnv = (Boolean)this.environment.getProperty(prefix + ".child-option.allow-half-closure", Boolean.class)) != null) {
                childOptionAllowHalfClosure = childOptionAllowHalfClosureFromEnv;
            }
            if ((readerIdleTimeSecondsFromEnv = (Integer)this.environment.getProperty(prefix + ".reader-idle-time-seconds", Integer.class)) != null) {
                readerIdleTimeSeconds = readerIdleTimeSecondsFromEnv;
            }
            if ((writerIdleTimeSecondsFromEnv = (Integer)this.environment.getProperty(prefix + ".writer-idle-time-seconds", Integer.class)) != null) {
                writerIdleTimeSeconds = writerIdleTimeSecondsFromEnv;
            }
            if ((allIdleTimeSecondsFromEnv = (Integer)this.environment.getProperty(prefix + ".all-idle-time-seconds", Integer.class)) != null) {
                allIdleTimeSeconds = allIdleTimeSecondsFromEnv;
            }
            if ((maxFramePayloadLengthEnv = (Integer)this.environment.getProperty(prefix + ".max-frame-payload-length", Integer.class)) != null) {
                maxFramePayloadLength = maxFramePayloadLengthEnv;
            }
        }
        ServerEndpointConfig serverEndpointConfig = new ServerEndpointConfig(host, port, path, bossLoopGroupThreads, workerLoopGroupThreads, useCompressionHandler, optionConnectTimeoutMillis, optionSoBacklog, childOptionWriteSpinCount, childOptionWriteBufferHighWaterMark, childOptionWriteBufferLowWaterMark, childOptionSoRcvbuf, childOptionSoSndbuf, childOptionTcpNodelay, childOptionSoKeepalive, childOptionSoLinger, childOptionAllowHalfClosure, readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, maxFramePayloadLength);
        return serverEndpointConfig;
    }

    public Set<InetSocketAddress> getInetSocketAddressSet() {
        return this.addressWebsocketServerMap.keySet();
    }
}

