/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.standard;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.yeauty.annotation.ServerEndpoint;
import org.yeauty.exception.DeploymentException;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.pojo.PojoMethodMapping;
import org.yeauty.standard.ServerEndpointConfig;
import org.yeauty.standard.WebsocketServer;

public class ServerEndpointExporter
extends ApplicationObjectSupport
implements SmartInitializingSingleton,
BeanFactoryAware {
    @Autowired
    Environment environment;
    private AbstractBeanFactory beanFactory;
    private final Map<InetSocketAddress, WebsocketServer> addressWebsocketServerMap = new HashMap<InetSocketAddress, WebsocketServer>();

    public void afterSingletonsInstantiated() {
        this.registerEndpoints();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a AbstractBeanFactory: " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
    }

    protected void registerEndpoints() {
        LinkedHashSet<Class> endpointClasses = new LinkedHashSet<Class>();
        ApplicationContext context = this.getApplicationContext();
        if (context != null) {
            String[] endpointBeanNames;
            for (String beanName : endpointBeanNames = context.getBeanNamesForAnnotation(ServerEndpoint.class)) {
                endpointClasses.add(context.getType(beanName));
            }
        }
        for (Class endpointClass : endpointClasses) {
            this.registerEndpoint(endpointClass);
        }
        this.init();
    }

    private void init() {
        for (Map.Entry<InetSocketAddress, WebsocketServer> entry : this.addressWebsocketServerMap.entrySet()) {
            WebsocketServer websocketServer = entry.getValue();
            try {
                websocketServer.init();
                PojoEndpointServer pojoEndpointServer = websocketServer.getPojoEndpointServer();
                StringJoiner stringJoiner = new StringJoiner(",");
                pojoEndpointServer.getPathMatcherSet().forEach(pathMatcher -> stringJoiner.add("'" + pathMatcher.getPattern() + "'"));
                this.logger.info((Object)("Netty WebSocket started on port: " + pojoEndpointServer.getPort() + " with context path(s): " + stringJoiner.toString()));
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("websocket [" + entry.getKey() + "] init fail"), (Throwable)e);
            }
        }
    }

    private void registerEndpoint(Class<?> endpointClass) {
        ServerEndpoint annotation = (ServerEndpoint)AnnotatedElementUtils.findMergedAnnotation(endpointClass, ServerEndpoint.class);
        if (annotation == null) {
            throw new IllegalStateException("missingAnnotation ServerEndpoint");
        }
        ServerEndpointConfig serverEndpointConfig = this.buildConfig(annotation);
        ApplicationContext context = this.getApplicationContext();
        PojoMethodMapping pojoMethodMapping = null;
        try {
            pojoMethodMapping = new PojoMethodMapping(endpointClass, context, this.beanFactory);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException("Failed to register ServerEndpointConfig: " + serverEndpointConfig, e);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverEndpointConfig.getHost(), serverEndpointConfig.getPort());
        String path = this.resolveAnnotationValue(annotation.value(), String.class, "path");
        WebsocketServer websocketServer = this.addressWebsocketServerMap.get(inetSocketAddress);
        if (websocketServer == null) {
            PojoEndpointServer pojoEndpointServer = new PojoEndpointServer(pojoMethodMapping, serverEndpointConfig, path);
            websocketServer = new WebsocketServer(pojoEndpointServer, serverEndpointConfig);
            this.addressWebsocketServerMap.put(inetSocketAddress, websocketServer);
        } else {
            websocketServer.getPojoEndpointServer().addPathPojoMethodMapping(path, pojoMethodMapping);
        }
    }

    private ServerEndpointConfig buildConfig(ServerEndpoint annotation) {
        String host = this.resolveAnnotationValue(annotation.host(), String.class, "host");
        int port = this.resolveAnnotationValue(annotation.port(), Integer.class, "port");
        String path = this.resolveAnnotationValue(annotation.value(), String.class, "value");
        int bossLoopGroupThreads = this.resolveAnnotationValue(annotation.bossLoopGroupThreads(), Integer.class, "bossLoopGroupThreads");
        int workerLoopGroupThreads = this.resolveAnnotationValue(annotation.workerLoopGroupThreads(), Integer.class, "workerLoopGroupThreads");
        boolean useCompressionHandler = this.resolveAnnotationValue(annotation.useCompressionHandler(), Boolean.class, "useCompressionHandler");
        int optionConnectTimeoutMillis = this.resolveAnnotationValue(annotation.optionConnectTimeoutMillis(), Integer.class, "optionConnectTimeoutMillis");
        int optionSoBacklog = this.resolveAnnotationValue(annotation.optionSoBacklog(), Integer.class, "optionSoBacklog");
        int childOptionWriteSpinCount = this.resolveAnnotationValue(annotation.childOptionWriteSpinCount(), Integer.class, "childOptionWriteSpinCount");
        int childOptionWriteBufferHighWaterMark = this.resolveAnnotationValue(annotation.childOptionWriteBufferHighWaterMark(), Integer.class, "childOptionWriteBufferHighWaterMark");
        int childOptionWriteBufferLowWaterMark = this.resolveAnnotationValue(annotation.childOptionWriteBufferLowWaterMark(), Integer.class, "childOptionWriteBufferLowWaterMark");
        int childOptionSoRcvbuf = this.resolveAnnotationValue(annotation.childOptionSoRcvbuf(), Integer.class, "childOptionSoRcvbuf");
        int childOptionSoSndbuf = this.resolveAnnotationValue(annotation.childOptionSoSndbuf(), Integer.class, "childOptionSoSndbuf");
        boolean childOptionTcpNodelay = this.resolveAnnotationValue(annotation.childOptionTcpNodelay(), Boolean.class, "childOptionTcpNodelay");
        boolean childOptionSoKeepalive = this.resolveAnnotationValue(annotation.childOptionSoKeepalive(), Boolean.class, "childOptionSoKeepalive");
        int childOptionSoLinger = this.resolveAnnotationValue(annotation.childOptionSoLinger(), Integer.class, "childOptionSoLinger");
        boolean childOptionAllowHalfClosure = this.resolveAnnotationValue(annotation.childOptionAllowHalfClosure(), Boolean.class, "childOptionAllowHalfClosure");
        int readerIdleTimeSeconds = this.resolveAnnotationValue(annotation.readerIdleTimeSeconds(), Integer.class, "readerIdleTimeSeconds");
        int writerIdleTimeSeconds = this.resolveAnnotationValue(annotation.writerIdleTimeSeconds(), Integer.class, "writerIdleTimeSeconds");
        int allIdleTimeSeconds = this.resolveAnnotationValue(annotation.allIdleTimeSeconds(), Integer.class, "allIdleTimeSeconds");
        int maxFramePayloadLength = this.resolveAnnotationValue(annotation.maxFramePayloadLength(), Integer.class, "maxFramePayloadLength");
        ServerEndpointConfig serverEndpointConfig = new ServerEndpointConfig(host, port, path, bossLoopGroupThreads, workerLoopGroupThreads, useCompressionHandler, optionConnectTimeoutMillis, optionSoBacklog, childOptionWriteSpinCount, childOptionWriteBufferHighWaterMark, childOptionWriteBufferLowWaterMark, childOptionSoRcvbuf, childOptionSoSndbuf, childOptionTcpNodelay, childOptionSoKeepalive, childOptionSoLinger, childOptionAllowHalfClosure, readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, maxFramePayloadLength);
        return serverEndpointConfig;
    }

    private <T> T resolveAnnotationValue(Object value, Class<T> requiredType, String paramName) {
        if (value == null) {
            return null;
        }
        TypeConverter typeConverter = this.beanFactory.getTypeConverter();
        if (typeConverter == null) {
            throw new IllegalArgumentException("TypeConverter of AbstractBeanFactory is null: " + this.beanFactory);
        }
        if (value instanceof String) {
            String strVal = this.beanFactory.resolveEmbeddedValue((String)value);
            BeanExpressionResolver beanExpressionResolver = this.beanFactory.getBeanExpressionResolver();
            value = beanExpressionResolver != null ? beanExpressionResolver.evaluate(strVal, new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null)) : strVal;
        }
        try {
            return (T)typeConverter.convertIfNecessary(value, requiredType);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException("Failed to convert value of parameter '" + paramName + "' to required type '" + requiredType.getName() + "'");
        }
    }
}

