/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.support;

import io.netty.channel.Channel;
import java.util.Map;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.core.MethodParameter;
import org.yeauty.annotation.PathVariable;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.support.MethodArgumentResolver;

public class PathVariableMethodArgumentResolver
implements MethodArgumentResolver {
    private AbstractBeanFactory beanFactory;

    public PathVariableMethodArgumentResolver(AbstractBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(PathVariable.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Channel channel, Object object) throws Exception {
        PathVariable ann = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        String name = ann.name();
        if (name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument type [" + parameter.getNestedParameterType().getName() + "] not available, and parameter name information not found in class file either.");
        }
        Map uriTemplateVars = (Map)channel.attr(PojoEndpointServer.URI_TEMPLATE).get();
        Object arg = uriTemplateVars != null ? uriTemplateVars.get(name) : null;
        TypeConverter typeConverter = this.beanFactory.getTypeConverter();
        return typeConverter.convertIfNecessary(arg, parameter.getParameterType());
    }
}

